/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.okhttp.implementation;

import com.azure.core.http.okhttp.implementation.OkHttpStreamableRequestBody;
import com.azure.core.implementation.util.InputStreamContent;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.MediaType;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class OkHttpInputStreamRequestBody
extends OkHttpStreamableRequestBody<InputStreamContent> {
    private static final ClientLogger LOGGER = new ClientLogger(OkHttpInputStreamRequestBody.class);
    private final AtomicBoolean bodySent = new AtomicBoolean(false);

    public OkHttpInputStreamRequestBody(InputStreamContent content, long effectiveContentLength, MediaType mediaType) {
        super(content, effectiveContentLength, mediaType);
    }

    public void writeTo(BufferedSink bufferedSink) throws IOException {
        if (!this.bodySent.compareAndSet(false, true)) {
            throw (IOException)LOGGER.logThrowableAsError((Throwable)new IOException("Re-attempt to send InputStream body is not supported."));
        }
        Source source = Okio.source((InputStream)((InputStreamContent)this.content).toStream());
        bufferedSink.writeAll(source);
    }
}

