/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.serializer;

import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.JsonSerializerProvider;
import java.util.Iterator;
import java.util.ServiceLoader;

public final class JsonSerializerProviders {
    private static final String CANNOT_FIND_JSON_SERIALIZER_PROVIDER = "A request was made to load the default JSON serializer provider but one could not be found on the classpath. If you are using a dependency manager, consider including a dependency on azure-core-serializer-json-jackson or azure-core-serializer-json-gson. Depending on your existing dependencies, you have the choice of Jackson or GSON implementations. Additionally, refer to https://aka.ms/azsdk/java/docs/custom-jsonserializer to learn about writing your own implementation.";
    private static JsonSerializerProvider defaultProvider;
    private static boolean attemptedLoad;

    public static JsonSerializer createInstance() {
        if (defaultProvider == null) {
            JsonSerializerProviders.loadFromClasspath();
        }
        return defaultProvider.createInstance();
    }

    private static synchronized void loadFromClasspath() {
        if (attemptedLoad && defaultProvider != null) {
            return;
        }
        if (attemptedLoad) {
            throw new IllegalStateException(CANNOT_FIND_JSON_SERIALIZER_PROVIDER);
        }
        attemptedLoad = true;
        Iterator<JsonSerializerProvider> iterator = ServiceLoader.load(JsonSerializerProvider.class).iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException(CANNOT_FIND_JSON_SERIALIZER_PROVIDER);
        }
        defaultProvider = iterator.next();
    }

    private JsonSerializerProviders() {
    }
}

