/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.serializer;

import com.azure.core.http.HttpResponse;
import com.azure.core.implementation.serializer.HttpResponseBodyDecoder;
import com.azure.core.implementation.serializer.HttpResponseDecodeData;
import com.azure.core.implementation.serializer.HttpResponseHeaderDecoder;
import com.azure.core.util.serializer.SerializerAdapter;
import java.io.Closeable;
import reactor.core.publisher.Mono;

public final class HttpResponseDecoder {
    private final SerializerAdapter serializer;

    public HttpResponseDecoder(SerializerAdapter serializer) {
        this.serializer = serializer;
    }

    public Mono<HttpDecodedResponse> decode(Mono<HttpResponse> response, HttpResponseDecodeData decodeData) {
        return response.map(r -> new HttpDecodedResponse((HttpResponse)r, this.serializer, decodeData));
    }

    public static final class HttpDecodedResponse
    implements Closeable {
        private final HttpResponse response;
        private final SerializerAdapter serializer;
        private final HttpResponseDecodeData decodeData;
        private Object bodyCached;
        private Object headersCached;

        HttpDecodedResponse(HttpResponse response, SerializerAdapter serializer, HttpResponseDecodeData decodeData) {
            this.response = response;
            this.serializer = serializer;
            this.decodeData = decodeData;
        }

        public HttpResponse getSourceResponse() {
            return this.response;
        }

        public Object getDecodedBody(byte[] body) {
            if (this.bodyCached == null) {
                this.bodyCached = HttpResponseBodyDecoder.decodeByteArray(body, this.response, this.serializer, this.decodeData);
            }
            return this.bodyCached;
        }

        public Object getDecodedHeaders() {
            if (this.headersCached == null) {
                this.headersCached = HttpResponseHeaderDecoder.decode(this.response, this.serializer, this.decodeData.getHeadersType());
            }
            return this.headersCached;
        }

        @Override
        public void close() {
            this.response.close();
        }
    }
}

