/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.UserAgentUtil;
import com.azure.core.util.builder.ClientBuilderUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.identity.CredentialUnavailableException;
import com.azure.identity.DeviceCodeInfo;
import com.azure.identity.TokenCachePersistenceOptions;
import com.azure.identity.implementation.CustomClaimRequest;
import com.azure.identity.implementation.HttpPipelineAdapter;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.PersistentTokenCacheImpl;
import com.azure.identity.implementation.RegionalAuthority;
import com.azure.identity.implementation.util.CertificateUtil;
import com.azure.identity.implementation.util.IdentityUtil;
import com.azure.identity.implementation.util.LoggingUtil;
import com.microsoft.aad.msal4j.ClaimsRequest;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.DeviceCodeFlowParameters;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.IClientSecret;
import com.microsoft.aad.msal4j.IHttpClient;
import com.microsoft.aad.msal4j.ITokenCacheAccessAspect;
import com.microsoft.aad.msal4j.InteractiveRequestParameters;
import com.microsoft.aad.msal4j.OnBehalfOfParameters;
import com.microsoft.aad.msal4j.Prompt;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.aad.msal4j.TokenProviderResult;
import com.microsoft.aad.msal4j.UserAssertion;
import com.microsoft.aad.msal4j.UserNamePasswordParameters;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import reactor.core.publisher.Mono;

public abstract class IdentityClientBase {
    static final SerializerAdapter SERIALIZER_ADAPTER = JacksonAdapter.createDefaultSerializerAdapter();
    static final String WINDOWS_STARTER = "cmd.exe";
    static final String LINUX_MAC_STARTER = "/bin/sh";
    static final String WINDOWS_SWITCHER = "/c";
    static final String LINUX_MAC_SWITCHER = "-c";
    static final String WINDOWS_PROCESS_ERROR_MESSAGE = "'az' is not recognized";
    static final Pattern LINUX_MAC_PROCESS_ERROR_MESSAGE = Pattern.compile("(.*)az:(.*)not found");
    static final String DEFAULT_WINDOWS_PS_EXECUTABLE = "pwsh.exe";
    static final String LEGACY_WINDOWS_PS_EXECUTABLE = "powershell.exe";
    static final String DEFAULT_LINUX_PS_EXECUTABLE = "pwsh";
    static final String DEFAULT_MAC_LINUX_PATH = "/bin/";
    static final Duration REFRESH_OFFSET = Duration.ofMinutes(5L);
    static final String IDENTITY_ENDPOINT_VERSION = "2019-08-01";
    static final String MSI_ENDPOINT_VERSION = "2017-09-01";
    static final String ARC_MANAGED_IDENTITY_ENDPOINT_API_VERSION = "2019-11-01";
    static final String ADFS_TENANT = "adfs";
    static final String HTTP_LOCALHOST = "http://localhost";
    static final String SERVICE_FABRIC_MANAGED_IDENTITY_API_VERSION = "2019-07-01-preview";
    static final ClientLogger LOGGER = new ClientLogger(IdentityClient.class);
    static final Pattern ACCESS_TOKEN_PATTERN = Pattern.compile("\"accessToken\": \"(.*?)(\"|$)");
    static final Pattern TRAILING_FORWARD_SLASHES = Pattern.compile("/+$");
    private static final String AZURE_IDENTITY_PROPERTIES = "azure-identity.properties";
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private final Map<String, String> properties;
    final IdentityClientOptions options;
    final String tenantId;
    final String clientId;
    final String resourceId;
    final String clientSecret;
    final String clientAssertionFilePath;
    final InputStream certificate;
    final String certificatePath;
    final Supplier<String> clientAssertionSupplier;
    final String certificatePassword;
    HttpPipelineAdapter httpPipelineAdapter;
    String userAgent = "azsdk-java";

    IdentityClientBase(String tenantId, String clientId, String clientSecret, String certificatePath, String clientAssertionFilePath, String resourceId, Supplier<String> clientAssertionSupplier, InputStream certificate, String certificatePassword, boolean isSharedTokenCacheCredential, Duration clientAssertionTimeout, IdentityClientOptions options) {
        if (tenantId == null) {
            tenantId = "organizations";
            options.setAdditionallyAllowedTenants(Collections.singletonList("*"));
        }
        if (options == null) {
            options = new IdentityClientOptions();
        }
        this.tenantId = tenantId;
        this.clientId = clientId;
        this.resourceId = resourceId;
        this.clientSecret = clientSecret;
        this.clientAssertionFilePath = clientAssertionFilePath;
        this.certificatePath = certificatePath;
        this.certificate = certificate;
        this.certificatePassword = certificatePassword;
        this.clientAssertionSupplier = clientAssertionSupplier;
        this.options = options;
        this.properties = CoreUtils.getProperties((String)AZURE_IDENTITY_PROPERTIES);
    }

    ConfidentialClientApplication getConfidentialClient() {
        IClientSecret credential;
        if (this.clientId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("A non-null value for client ID must be provided for user authentication."));
        }
        String authorityUrl = TRAILING_FORWARD_SLASHES.matcher(this.options.getAuthorityHost()).replaceAll("") + "/" + this.tenantId;
        if (this.clientSecret != null) {
            credential = ClientCredentialFactory.createFromSecret((String)this.clientSecret);
        } else if (this.certificate != null || this.certificatePath != null) {
            try {
                if (this.certificatePassword == null) {
                    byte[] pemCertificateBytes = this.getCertificateBytes();
                    List<X509Certificate> x509CertificateList = CertificateUtil.publicKeyFromPem(pemCertificateBytes);
                    PrivateKey privateKey = CertificateUtil.privateKeyFromPem(pemCertificateBytes);
                    if (x509CertificateList.size() == 1) {
                        credential = ClientCredentialFactory.createFromCertificate((PrivateKey)privateKey, (X509Certificate)x509CertificateList.get(0));
                    }
                    credential = ClientCredentialFactory.createFromCertificateChain((PrivateKey)privateKey, x509CertificateList);
                }
                try (InputStream pfxCertificateStream = this.getCertificateInputStream();){
                    credential = ClientCredentialFactory.createFromCertificate((InputStream)pfxCertificateStream, (String)this.certificatePassword);
                }
            }
            catch (IOException | GeneralSecurityException e) {
                throw LOGGER.logExceptionAsError(new RuntimeException("Failed to parse the certificate for the credential: " + e.getMessage(), e));
            }
        } else if (this.clientAssertionSupplier != null) {
            credential = ClientCredentialFactory.createFromClientAssertion((String)this.clientAssertionSupplier.get());
        } else {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Must provide client secret or client certificate path. To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/serviceprincipalauthentication/troubleshoot"));
        }
        ConfidentialClientApplication.Builder applicationBuilder = ConfidentialClientApplication.builder((String)this.clientId, (IClientCredential)credential);
        try {
            applicationBuilder = (ConfidentialClientApplication.Builder)applicationBuilder.authority(authorityUrl);
        }
        catch (MalformedURLException e) {
            throw LOGGER.logExceptionAsWarning((RuntimeException)new IllegalStateException(e));
        }
        applicationBuilder.sendX5c(this.options.isIncludeX5c());
        this.initializeHttpPipelineAdapter();
        if (this.httpPipelineAdapter != null) {
            applicationBuilder.httpClient((IHttpClient)this.httpPipelineAdapter);
        } else {
            applicationBuilder.proxy(IdentityClientBase.proxyOptionsToJavaNetProxy(this.options.getProxyOptions()));
        }
        if (this.options.getExecutorService() != null) {
            applicationBuilder.executorService(this.options.getExecutorService());
        }
        TokenCachePersistenceOptions tokenCachePersistenceOptions = this.options.getTokenCacheOptions();
        PersistentTokenCacheImpl tokenCache = null;
        if (tokenCachePersistenceOptions != null) {
            try {
                tokenCache = new PersistentTokenCacheImpl().setAllowUnencryptedStorage(tokenCachePersistenceOptions.isUnencryptedStorageAllowed()).setName(tokenCachePersistenceOptions.getName());
                applicationBuilder.setTokenCacheAccessAspect((ITokenCacheAccessAspect)tokenCache);
            }
            catch (Throwable t) {
                throw LOGGER.logExceptionAsError((RuntimeException)new ClientAuthenticationException("Shared token cache is unavailable in this environment.", null, t));
            }
        }
        if (this.options.getRegionalAuthority() != null) {
            if (this.options.getRegionalAuthority() == RegionalAuthority.AUTO_DISCOVER_REGION) {
                applicationBuilder.autoDetectRegion(true);
            } else {
                applicationBuilder.azureRegion(this.options.getRegionalAuthority().toString());
            }
        }
        ConfidentialClientApplication confidentialClientApplication = applicationBuilder.build();
        if (tokenCache != null) {
            tokenCache.registerCache();
        }
        return confidentialClientApplication;
    }

    PublicClientApplication getPublicClient(boolean sharedTokenCacheCredential) {
        if (this.clientId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("A non-null value for client ID must be provided for user authentication."));
        }
        String authorityUrl = TRAILING_FORWARD_SLASHES.matcher(this.options.getAuthorityHost()).replaceAll("") + "/" + this.tenantId;
        PublicClientApplication.Builder builder = PublicClientApplication.builder((String)this.clientId);
        try {
            builder = (PublicClientApplication.Builder)builder.authority(authorityUrl);
        }
        catch (MalformedURLException e) {
            throw LOGGER.logExceptionAsWarning((RuntimeException)new IllegalStateException(e));
        }
        this.initializeHttpPipelineAdapter();
        if (this.httpPipelineAdapter != null) {
            builder.httpClient((IHttpClient)this.httpPipelineAdapter);
        } else {
            builder.proxy(IdentityClientBase.proxyOptionsToJavaNetProxy(this.options.getProxyOptions()));
        }
        if (this.options.getExecutorService() != null) {
            builder.executorService(this.options.getExecutorService());
        }
        if (!this.options.isCp1Disabled()) {
            HashSet<String> set = new HashSet<String>(1);
            set.add("CP1");
            builder.clientCapabilities(set);
        }
        TokenCachePersistenceOptions tokenCachePersistenceOptions = this.options.getTokenCacheOptions();
        PersistentTokenCacheImpl tokenCache = null;
        if (tokenCachePersistenceOptions != null) {
            try {
                tokenCache = new PersistentTokenCacheImpl().setAllowUnencryptedStorage(tokenCachePersistenceOptions.isUnencryptedStorageAllowed()).setName(tokenCachePersistenceOptions.getName());
                builder.setTokenCacheAccessAspect((ITokenCacheAccessAspect)tokenCache);
            }
            catch (Throwable t) {
                throw LOGGER.logExceptionAsError((RuntimeException)new ClientAuthenticationException("Shared token cache is unavailable in this environment.", null, t));
            }
        }
        PublicClientApplication publicClientApplication = builder.build();
        if (tokenCache != null) {
            tokenCache.registerCache();
        }
        return publicClientApplication;
    }

    ConfidentialClientApplication getManagedIdentityConfidentialClient() {
        String authorityUrl = TRAILING_FORWARD_SLASHES.matcher(this.options.getAuthorityHost()).replaceAll("") + "/" + this.tenantId;
        IClientSecret credential = ClientCredentialFactory.createFromSecret((String)(this.clientSecret != null ? this.clientSecret : "dummy-secret"));
        ConfidentialClientApplication.Builder applicationBuilder = ConfidentialClientApplication.builder((String)(this.clientId == null ? "SYSTEM-ASSIGNED-MANAGED-IDENTITY" : this.clientId), (IClientCredential)credential);
        applicationBuilder.validateAuthority(false);
        try {
            applicationBuilder = (ConfidentialClientApplication.Builder)applicationBuilder.authority(authorityUrl);
        }
        catch (MalformedURLException e) {
            throw LOGGER.logExceptionAsWarning((RuntimeException)new IllegalStateException(e));
        }
        if (this.options.getManagedIdentityType() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)new CredentialUnavailableException("Managed Identity type not configured, authentication not available.")));
        }
        applicationBuilder.appTokenProvider(appTokenProviderParameters -> {
            TokenRequestContext trc = new TokenRequestContext().setScopes(new ArrayList(appTokenProviderParameters.scopes)).setClaims(appTokenProviderParameters.claims).setTenantId(appTokenProviderParameters.tenantId);
            Mono<AccessToken> accessTokenAsync = this.getTokenFromTargetManagedIdentity(trc);
            return accessTokenAsync.map(accessToken -> {
                TokenProviderResult result = new TokenProviderResult();
                result.setAccessToken(accessToken.getToken());
                result.setTenantId(trc.getTenantId());
                result.setExpiresInSeconds(accessToken.getExpiresAt().toEpochSecond());
                return result;
            }).toFuture();
        });
        this.initializeHttpPipelineAdapter();
        if (this.httpPipelineAdapter != null) {
            applicationBuilder.httpClient((IHttpClient)this.httpPipelineAdapter);
        } else {
            applicationBuilder.proxy(IdentityClientBase.proxyOptionsToJavaNetProxy(this.options.getProxyOptions()));
        }
        if (this.options.getExecutorService() != null) {
            applicationBuilder.executorService(this.options.getExecutorService());
        }
        return applicationBuilder.build();
    }

    DeviceCodeFlowParameters.DeviceCodeFlowParametersBuilder buildDeviceCodeFlowParameters(TokenRequestContext request, Consumer<DeviceCodeInfo> deviceCodeConsumer) {
        DeviceCodeFlowParameters.DeviceCodeFlowParametersBuilder parametersBuilder = DeviceCodeFlowParameters.builder(new HashSet(request.getScopes()), dc -> deviceCodeConsumer.accept(new DeviceCodeInfo(dc.userCode(), dc.deviceCode(), dc.verificationUri(), OffsetDateTime.now().plusSeconds(dc.expiresIn()), dc.message()))).tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
        if (request.getClaims() != null) {
            ClaimsRequest customClaimRequest = CustomClaimRequest.formatAsClaimsRequest(request.getClaims());
            parametersBuilder.claims(customClaimRequest);
        }
        return parametersBuilder;
    }

    OnBehalfOfParameters buildOBOFlowParameters(TokenRequestContext request) {
        return OnBehalfOfParameters.builder(new HashSet(request.getScopes()), (UserAssertion)this.options.getUserAssertion()).tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options)).build();
    }

    InteractiveRequestParameters.InteractiveRequestParametersBuilder buildInteractiveRequestParameters(TokenRequestContext request, String loginHint, URI redirectUri) {
        InteractiveRequestParameters.InteractiveRequestParametersBuilder builder = InteractiveRequestParameters.builder((URI)redirectUri).scopes(new HashSet(request.getScopes())).prompt(Prompt.SELECT_ACCOUNT).tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
        if (request.getClaims() != null) {
            ClaimsRequest customClaimRequest = CustomClaimRequest.formatAsClaimsRequest(request.getClaims());
            builder.claims(customClaimRequest);
        }
        if (loginHint != null) {
            builder.loginHint(loginHint);
        }
        return builder;
    }

    UserNamePasswordParameters.UserNamePasswordParametersBuilder buildUsernamePasswordFlowParameters(TokenRequestContext request, String username, String password) {
        UserNamePasswordParameters.UserNamePasswordParametersBuilder userNamePasswordParametersBuilder = UserNamePasswordParameters.builder(new HashSet(request.getScopes()), (String)username, (char[])password.toCharArray());
        if (request.getClaims() != null) {
            ClaimsRequest customClaimRequest = CustomClaimRequest.formatAsClaimsRequest(request.getClaims());
            userNamePasswordParametersBuilder.claims(customClaimRequest);
        }
        userNamePasswordParametersBuilder.tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
        return userNamePasswordParametersBuilder;
    }

    AccessToken getTokenFromAzureCLIAuthentication(StringBuilder azCommand) {
        AccessToken token;
        try {
            String switcher;
            String starter;
            if (this.isWindowsPlatform()) {
                starter = WINDOWS_STARTER;
                switcher = WINDOWS_SWITCHER;
            } else {
                starter = LINUX_MAC_STARTER;
                switcher = LINUX_MAC_SWITCHER;
            }
            ProcessBuilder builder = new ProcessBuilder(starter, switcher, azCommand.toString());
            String workingDirectory = this.getSafeWorkingDirectory();
            if (workingDirectory == null) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("A Safe Working directory could not be found to execute CLI command from. To mitigate this issue, please refer to the troubleshooting  guidelines here at https://aka.ms/azsdk/java/identity/azclicredential/troubleshoot"));
            }
            builder.directory(new File(workingDirectory));
            builder.redirectErrorStream(true);
            Process process = builder.start();
            StringBuilder output = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith(WINDOWS_PROCESS_ERROR_MESSAGE) || LINUX_MAC_PROCESS_ERROR_MESSAGE.matcher(line).matches()) {
                        throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("AzureCliCredential authentication unavailable. Azure CLI not installed.To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/azclicredential/troubleshoot"));
                    }
                    output.append(line);
                }
            }
            String processOutput = output.toString();
            process.waitFor(10L, TimeUnit.SECONDS);
            if (process.exitValue() != 0) {
                if (processOutput.length() > 0) {
                    String redactedOutput = this.redactInfo(processOutput);
                    if (redactedOutput.contains("az login") || redactedOutput.contains("az account set")) {
                        throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("AzureCliCredential authentication unavailable. Please run 'az login' to set up account. To further mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/azclicredential/troubleshoot"));
                    }
                    throw LOGGER.logExceptionAsError((RuntimeException)new ClientAuthenticationException(redactedOutput, null));
                }
                throw LOGGER.logExceptionAsError((RuntimeException)new ClientAuthenticationException("Failed to invoke Azure CLI ", null));
            }
            LOGGER.verbose("Azure CLI Authentication => A token response was received from Azure CLI, deserializing the response into an Access Token.");
            Map objectMap = (Map)SERIALIZER_ADAPTER.deserialize(processOutput, Map.class, SerializerEncoding.JSON);
            String accessToken = (String)objectMap.get("accessToken");
            String time = (String)objectMap.get("expiresOn");
            String timeToSecond = time.substring(0, time.indexOf("."));
            String timeJoinedWithT = String.join((CharSequence)"T", timeToSecond.split(" "));
            OffsetDateTime expiresOn = LocalDateTime.parse(timeJoinedWithT, DateTimeFormatter.ISO_LOCAL_DATE_TIME).atZone(ZoneId.systemDefault()).toOffsetDateTime().withOffsetSameInstant(ZoneOffset.UTC);
            token = new AccessToken(accessToken, expiresOn);
        }
        catch (IOException | InterruptedException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(e));
        }
        return token;
    }

    String getSafeWorkingDirectory() {
        if (this.isWindowsPlatform()) {
            String windowsSystemRoot = System.getenv("SystemRoot");
            if (CoreUtils.isNullOrEmpty((CharSequence)windowsSystemRoot)) {
                return null;
            }
            return windowsSystemRoot + "\\system32";
        }
        return DEFAULT_MAC_LINUX_PATH;
    }

    boolean isWindowsPlatform() {
        return System.getProperty("os.name").contains("Windows");
    }

    String redactInfo(String input) {
        return ACCESS_TOKEN_PATTERN.matcher(input).replaceAll("****");
    }

    abstract Mono<AccessToken> getTokenFromTargetManagedIdentity(TokenRequestContext var1);

    HttpPipeline setupPipeline(HttpClient httpClient) {
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = this.properties.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = this.properties.getOrDefault(SDK_VERSION, "UnknownVersion");
        Configuration buildConfiguration = Configuration.getGlobalConfiguration().clone();
        HttpLogOptions httpLogOptions = this.options.getHttpLogOptions() == null ? new HttpLogOptions() : this.options.getHttpLogOptions();
        this.userAgent = UserAgentUtil.toUserAgentString((String)CoreUtils.getApplicationId((ClientOptions)this.options.getClientOptions(), (HttpLogOptions)httpLogOptions), (String)clientName, (String)clientVersion, (Configuration)buildConfiguration);
        policies.add(new UserAgentPolicy(this.userAgent));
        if (this.options.getClientOptions() != null) {
            ArrayList httpHeaderList = new ArrayList();
            this.options.getClientOptions().getHeaders().forEach(header -> httpHeaderList.add(new HttpHeader(header.getName(), header.getValue())));
            policies.add(new AddHeadersPolicy(new HttpHeaders(httpHeaderList)));
        }
        policies.addAll(this.options.getPerCallPolicies());
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(ClientBuilderUtil.validateAndGetRetryPolicy((HttpPipelinePolicy)this.options.getRetryPolicy(), (RetryOptions)this.options.getRetryOptions()));
        policies.addAll(this.options.getPerRetryPolicies());
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(httpLogOptions));
        return new HttpPipelineBuilder().httpClient(httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
    }

    void initializeHttpPipelineAdapter() {
        HttpPipeline httpPipeline = this.options.getHttpPipeline();
        if (httpPipeline != null) {
            this.httpPipelineAdapter = new HttpPipelineAdapter(httpPipeline, this.options);
        } else {
            HttpClient httpClient = this.options.getHttpClient();
            if (httpClient != null) {
                this.httpPipelineAdapter = new HttpPipelineAdapter(this.setupPipeline(httpClient), this.options);
            } else if (this.options.getProxyOptions() == null) {
                this.httpPipelineAdapter = new HttpPipelineAdapter(this.setupPipeline(HttpClient.createDefault()), this.options);
            }
        }
    }

    private byte[] getCertificateBytes() throws IOException {
        if (this.certificatePath != null) {
            return Files.readAllBytes(Paths.get(this.certificatePath, new String[0]));
        }
        if (this.certificate != null) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int read = this.certificate.read(buffer, 0, buffer.length);
            while (read != -1) {
                outputStream.write(buffer, 0, read);
                read = this.certificate.read(buffer, 0, buffer.length);
            }
            return outputStream.toByteArray();
        }
        return new byte[0];
    }

    private InputStream getCertificateInputStream() throws IOException {
        if (this.certificatePath != null) {
            return new BufferedInputStream(new FileInputStream(this.certificatePath));
        }
        return this.certificate;
    }

    private static Proxy proxyOptionsToJavaNetProxy(ProxyOptions options) {
        switch (options.getType()) {
            case SOCKS4: 
            case SOCKS5: {
                return new Proxy(Proxy.Type.SOCKS, options.getAddress());
            }
        }
        return new Proxy(Proxy.Type.HTTP, options.getAddress());
    }
}

