/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.models;

import com.azure.messaging.servicebus.administration.models.AuthorizationRule;
import com.azure.messaging.servicebus.administration.models.EntityStatus;
import com.azure.messaging.servicebus.administration.models.QueueProperties;
import com.azure.messaging.servicebus.implementation.ServiceBusConstants;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class CreateQueueOptions {
    private final List<AuthorizationRule> authorizationRules;
    private Duration autoDeleteOnIdle;
    private Duration defaultMessageTimeToLive;
    private boolean deadLetteringOnMessageExpiration;
    private Duration duplicateDetectionHistoryTimeWindow;
    private boolean enableBatchedOperations;
    private boolean enablePartitioning;
    private String forwardTo;
    private String forwardDeadLetteredMessagesTo;
    private Duration lockDuration;
    private int maxDeliveryCount;
    private long maxMessageSizeInKilobytes;
    private long maxSizeInMegabytes;
    private boolean requiresDuplicateDetection;
    private boolean requiresSession;
    private String userMetadata;
    private EntityStatus status;

    public CreateQueueOptions() {
        this.authorizationRules = new ArrayList<AuthorizationRule>();
        this.autoDeleteOnIdle = ServiceBusConstants.MAX_DURATION;
        this.defaultMessageTimeToLive = ServiceBusConstants.MAX_DURATION;
        this.duplicateDetectionHistoryTimeWindow = ServiceBusConstants.DEFAULT_DUPLICATE_DETECTION_DURATION;
        this.enableBatchedOperations = true;
        this.enablePartitioning = false;
        this.lockDuration = ServiceBusConstants.DEFAULT_LOCK_DURATION;
        this.maxDeliveryCount = 10;
        this.maxSizeInMegabytes = 1024L;
        this.requiresDuplicateDetection = false;
        this.requiresSession = false;
        this.deadLetteringOnMessageExpiration = false;
        this.status = EntityStatus.ACTIVE;
    }

    public CreateQueueOptions(QueueProperties queue) {
        Objects.requireNonNull(queue, "'queue' cannot be null.");
        this.authorizationRules = new ArrayList<AuthorizationRule>(queue.getAuthorizationRules());
        this.autoDeleteOnIdle = queue.getAutoDeleteOnIdle();
        this.defaultMessageTimeToLive = queue.getDefaultMessageTimeToLive();
        this.deadLetteringOnMessageExpiration = queue.isDeadLetteringOnMessageExpiration();
        this.duplicateDetectionHistoryTimeWindow = queue.getDuplicateDetectionHistoryTimeWindow() != null ? queue.getDuplicateDetectionHistoryTimeWindow() : ServiceBusConstants.DEFAULT_DUPLICATE_DETECTION_DURATION;
        this.enableBatchedOperations = queue.isBatchedOperationsEnabled();
        this.enablePartitioning = queue.isPartitioningEnabled();
        this.forwardTo = queue.getForwardTo();
        this.forwardDeadLetteredMessagesTo = queue.getForwardDeadLetteredMessagesTo();
        this.lockDuration = queue.getLockDuration();
        this.maxDeliveryCount = queue.getMaxDeliveryCount();
        this.maxMessageSizeInKilobytes = queue.getMaxMessageSizeInKilobytes();
        this.maxSizeInMegabytes = queue.getMaxSizeInMegabytes();
        this.requiresDuplicateDetection = queue.isDuplicateDetectionRequired();
        this.requiresSession = queue.isSessionRequired();
        this.status = queue.getStatus();
        this.userMetadata = queue.getUserMetadata();
    }

    public List<AuthorizationRule> getAuthorizationRules() {
        return this.authorizationRules;
    }

    public Duration getAutoDeleteOnIdle() {
        return this.autoDeleteOnIdle;
    }

    public CreateQueueOptions setAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
        this.autoDeleteOnIdle = autoDeleteOnIdle;
        return this;
    }

    public Duration getDefaultMessageTimeToLive() {
        return this.defaultMessageTimeToLive;
    }

    public CreateQueueOptions setDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
        this.defaultMessageTimeToLive = defaultMessageTimeToLive;
        return this;
    }

    public boolean isDeadLetteringOnMessageExpiration() {
        return this.deadLetteringOnMessageExpiration;
    }

    public CreateQueueOptions setDeadLetteringOnMessageExpiration(boolean deadLetteringOnMessageExpiration) {
        this.deadLetteringOnMessageExpiration = deadLetteringOnMessageExpiration;
        return this;
    }

    public Duration getDuplicateDetectionHistoryTimeWindow() {
        return this.duplicateDetectionHistoryTimeWindow;
    }

    public CreateQueueOptions setDuplicateDetectionHistoryTimeWindow(Duration duplicateDetectionHistoryTimeWindow) {
        this.duplicateDetectionHistoryTimeWindow = duplicateDetectionHistoryTimeWindow;
        return this;
    }

    public boolean isBatchedOperationsEnabled() {
        return this.enableBatchedOperations;
    }

    public CreateQueueOptions setBatchedOperationsEnabled(boolean enableBatchedOperations) {
        this.enableBatchedOperations = enableBatchedOperations;
        return this;
    }

    public boolean isPartitioningEnabled() {
        return this.enablePartitioning;
    }

    public CreateQueueOptions setPartitioningEnabled(boolean enablePartitioning) {
        this.enablePartitioning = enablePartitioning;
        return this;
    }

    public String getForwardTo() {
        return this.forwardTo;
    }

    public CreateQueueOptions setForwardTo(String forwardTo) {
        this.forwardTo = forwardTo;
        return this;
    }

    public String getForwardDeadLetteredMessagesTo() {
        return this.forwardDeadLetteredMessagesTo;
    }

    public CreateQueueOptions setForwardDeadLetteredMessagesTo(String forwardDeadLetteredMessagesTo) {
        this.forwardDeadLetteredMessagesTo = forwardDeadLetteredMessagesTo;
        return this;
    }

    public Duration getLockDuration() {
        return this.lockDuration;
    }

    public CreateQueueOptions setLockDuration(Duration lockDuration) {
        this.lockDuration = lockDuration;
        return this;
    }

    public int getMaxDeliveryCount() {
        return this.maxDeliveryCount;
    }

    public CreateQueueOptions setMaxDeliveryCount(int maxDeliveryCount) {
        this.maxDeliveryCount = maxDeliveryCount;
        return this;
    }

    public long getMaxSizeInMegabytes() {
        return this.maxSizeInMegabytes;
    }

    public CreateQueueOptions setMaxSizeInMegabytes(int maxSizeInMegabytes) {
        this.maxSizeInMegabytes = maxSizeInMegabytes;
        return this;
    }

    public boolean isDuplicateDetectionRequired() {
        return this.requiresDuplicateDetection;
    }

    public CreateQueueOptions setDuplicateDetectionRequired(boolean requiresDuplicateDetection) {
        this.requiresDuplicateDetection = requiresDuplicateDetection;
        return this;
    }

    public boolean isSessionRequired() {
        return this.requiresSession;
    }

    public CreateQueueOptions setSessionRequired(boolean requiresSession) {
        this.requiresSession = requiresSession;
        return this;
    }

    public EntityStatus getStatus() {
        return this.status;
    }

    public CreateQueueOptions setStatus(EntityStatus status) {
        this.status = status;
        return this;
    }

    public String getUserMetadata() {
        return this.userMetadata;
    }

    public CreateQueueOptions setUserMetadata(String userMetadata) {
        this.userMetadata = userMetadata;
        return this;
    }

    public long getMaxMessageSizeInKilobytes() {
        return this.maxMessageSizeInKilobytes;
    }

    public CreateQueueOptions setMaxMessageSizeInKilobytes(long maxMessageSizeInKilobytes) {
        this.maxMessageSizeInKilobytes = maxMessageSizeInKilobytes;
        return this;
    }
}

