/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.models;

import com.azure.messaging.servicebus.administration.implementation.EntityHelper;
import com.azure.messaging.servicebus.administration.implementation.models.CorrelationFilter;
import com.azure.messaging.servicebus.administration.implementation.models.FalseFilter;
import com.azure.messaging.servicebus.administration.implementation.models.KeyValue;
import com.azure.messaging.servicebus.administration.implementation.models.RuleDescription;
import com.azure.messaging.servicebus.administration.implementation.models.SqlFilter;
import com.azure.messaging.servicebus.administration.implementation.models.TrueFilter;
import com.azure.messaging.servicebus.administration.models.CorrelationRuleFilter;
import com.azure.messaging.servicebus.administration.models.EmptyRuleAction;
import com.azure.messaging.servicebus.administration.models.FalseRuleFilter;
import com.azure.messaging.servicebus.administration.models.RuleAction;
import com.azure.messaging.servicebus.administration.models.RuleFilter;
import com.azure.messaging.servicebus.administration.models.SqlRuleAction;
import com.azure.messaging.servicebus.administration.models.SqlRuleFilter;
import com.azure.messaging.servicebus.administration.models.TrueRuleFilter;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class RuleProperties {
    private final String name;
    private RuleFilter filter;
    private RuleAction action;

    RuleProperties(String name, RuleFilter filter, RuleAction action) {
        this.name = name;
        this.filter = filter;
        this.action = action;
    }

    public RuleFilter getFilter() {
        return this.filter;
    }

    public RuleProperties setFilter(RuleFilter filter) {
        this.filter = Objects.requireNonNull(filter, "'filter' cannot be null.");
        return this;
    }

    public String getName() {
        return this.name;
    }

    public RuleAction getAction() {
        return this.action;
    }

    public RuleProperties setAction(RuleAction action) {
        this.action = action;
        return this;
    }

    static {
        EntityHelper.setRuleAccessor(new EntityHelper.RuleAccessor(){
            private final com.azure.messaging.servicebus.administration.implementation.models.EmptyRuleAction emptyRuleAction = new com.azure.messaging.servicebus.administration.implementation.models.EmptyRuleAction();
            private final SqlFilter trueFilter = new TrueFilter().setSqlExpression("1=1");
            private final SqlFilter falseFilter = new FalseFilter().setSqlExpression("1=0");

            @Override
            public RuleProperties toModel(RuleDescription description) {
                RuleFilter filter = description.getFilter() != null ? this.toModel(description.getFilter()) : null;
                RuleAction action = description.getAction() != null ? this.toModel(description.getAction()) : null;
                return new RuleProperties(description.getName(), filter, action);
            }

            @Override
            public RuleAction toModel(com.azure.messaging.servicebus.administration.implementation.models.RuleAction implementation) {
                if (implementation instanceof com.azure.messaging.servicebus.administration.implementation.models.EmptyRuleAction) {
                    return EmptyRuleAction.getInstance();
                }
                if (implementation instanceof com.azure.messaging.servicebus.administration.implementation.models.SqlRuleAction) {
                    com.azure.messaging.servicebus.administration.implementation.models.SqlRuleAction action = (com.azure.messaging.servicebus.administration.implementation.models.SqlRuleAction)implementation;
                    SqlRuleAction returned = new SqlRuleAction(action.getSqlExpression(), action.getCompatibilityLevel(), action.isRequiresPreprocessing());
                    if (action.getParameters() != null) {
                        for (KeyValue parameter : action.getParameters()) {
                            returned.getParameters().put(parameter.getKey(), parameter.getValue());
                        }
                    }
                    return returned;
                }
                return null;
            }

            @Override
            public RuleFilter toModel(com.azure.messaging.servicebus.administration.implementation.models.RuleFilter implementation) {
                if (implementation instanceof TrueFilter) {
                    return TrueRuleFilter.getInstance();
                }
                if (implementation instanceof FalseFilter) {
                    return FalseRuleFilter.getInstance();
                }
                if (implementation instanceof CorrelationFilter) {
                    CorrelationFilter filter = (CorrelationFilter)implementation;
                    CorrelationRuleFilter returned = new CorrelationRuleFilter().setContentType(filter.getContentType()).setCorrelationId(filter.getCorrelationId()).setLabel(filter.getLabel()).setMessageId(filter.getMessageId()).setTo(filter.getTo()).setSessionId(filter.getSessionId()).setReplyTo(filter.getReplyTo()).setReplyToSessionId(filter.getReplyToSessionId());
                    if (filter.getProperties() != null) {
                        filter.getProperties().forEach(keyValue -> returned.getProperties().put(keyValue.getKey(), keyValue.getValue()));
                    }
                    return returned;
                }
                if (implementation instanceof SqlFilter) {
                    SqlFilter filter = (SqlFilter)implementation;
                    SqlRuleFilter returned = new SqlRuleFilter(filter.getSqlExpression(), filter.getCompatibilityLevel(), filter.isRequiresPreprocessing());
                    if (filter.getParameters() != null) {
                        filter.getParameters().forEach(keyValue -> returned.getParameters().put(keyValue.getKey(), keyValue.getValue()));
                    }
                    return returned;
                }
                return null;
            }

            @Override
            public RuleDescription toImplementation(RuleProperties ruleProperties) {
                com.azure.messaging.servicebus.administration.implementation.models.RuleFilter filter = ruleProperties.getFilter() != null ? this.toImplementation(ruleProperties.getFilter()) : null;
                com.azure.messaging.servicebus.administration.implementation.models.RuleAction action = ruleProperties.getAction() != null ? this.toImplementation(ruleProperties.getAction()) : null;
                return new RuleDescription().setName(ruleProperties.getName()).setAction(action).setFilter(filter);
            }

            @Override
            public com.azure.messaging.servicebus.administration.implementation.models.RuleAction toImplementation(RuleAction model) {
                if (model instanceof EmptyRuleAction) {
                    return this.emptyRuleAction;
                }
                if (model instanceof SqlRuleAction) {
                    SqlRuleAction action = (SqlRuleAction)model;
                    com.azure.messaging.servicebus.administration.implementation.models.SqlRuleAction returned = new com.azure.messaging.servicebus.administration.implementation.models.SqlRuleAction().setSqlExpression(action.getSqlExpression()).setCompatibilityLevel(action.getCompatibilityLevel()).setRequiresPreprocessing(action.isPreprocessingRequired());
                    if (!action.getParameters().isEmpty()) {
                        List<KeyValue> parameters = action.getParameters().entrySet().stream().map(entry -> new KeyValue().setKey((String)entry.getKey()).setValue(entry.getValue().toString())).collect(Collectors.toList());
                        returned.setParameters(parameters);
                    }
                    return returned;
                }
                return null;
            }

            @Override
            public com.azure.messaging.servicebus.administration.implementation.models.RuleFilter toImplementation(RuleFilter model) {
                if (model instanceof TrueRuleFilter) {
                    return this.trueFilter;
                }
                if (model instanceof FalseRuleFilter) {
                    return this.falseFilter;
                }
                if (model instanceof CorrelationRuleFilter) {
                    CorrelationRuleFilter filter = (CorrelationRuleFilter)model;
                    CorrelationFilter returned = new CorrelationFilter().setContentType(filter.getContentType()).setCorrelationId(filter.getCorrelationId()).setLabel(filter.getLabel()).setMessageId(filter.getMessageId()).setTo(filter.getTo()).setSessionId(filter.getSessionId()).setReplyTo(filter.getReplyTo()).setReplyToSessionId(filter.getReplyToSessionId());
                    if (!filter.getProperties().isEmpty()) {
                        List<KeyValue> parameters = filter.getProperties().entrySet().stream().map(entry -> new KeyValue().setKey((String)entry.getKey()).setValue(entry.getValue().toString())).collect(Collectors.toList());
                        returned.setProperties(parameters);
                    }
                    return returned;
                }
                if (model instanceof SqlRuleFilter) {
                    SqlRuleFilter filter = (SqlRuleFilter)model;
                    SqlFilter returned = new SqlFilter().setSqlExpression(filter.getSqlExpression()).setCompatibilityLevel(filter.getCompatibilityLevel()).setRequiresPreprocessing(filter.isPreprocessingRequired());
                    if (!filter.getParameters().isEmpty()) {
                        List<KeyValue> parameters = filter.getParameters().entrySet().stream().map(entry -> new KeyValue().setKey((String)entry.getKey()).setValue(entry.getValue().toString())).collect(Collectors.toList());
                        returned.setParameters(parameters);
                    }
                    return returned;
                }
                return null;
            }
        });
    }
}

