/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.implementation;

import com.azure.core.amqp.AmqpRetryMode;
import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.LoggingEventBuilder;
import com.azure.messaging.servicebus.ServiceBusTransactionContext;
import com.azure.messaging.servicebus.administration.implementation.EntityHelper;
import com.azure.messaging.servicebus.administration.implementation.models.RuleDescription;
import com.azure.messaging.servicebus.administration.models.CorrelationRuleFilter;
import com.azure.messaging.servicebus.administration.models.CreateRuleOptions;
import com.azure.messaging.servicebus.administration.models.FalseRuleFilter;
import com.azure.messaging.servicebus.administration.models.RuleAction;
import com.azure.messaging.servicebus.administration.models.RuleFilter;
import com.azure.messaging.servicebus.administration.models.RuleProperties;
import com.azure.messaging.servicebus.administration.models.SqlRuleAction;
import com.azure.messaging.servicebus.administration.models.SqlRuleFilter;
import com.azure.messaging.servicebus.administration.models.TrueRuleFilter;
import com.azure.messaging.servicebus.implementation.DispositionStatus;
import com.azure.messaging.servicebus.implementation.ServiceBusConstants;
import java.net.URI;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Outcome;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.transaction.TransactionalState;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class MessageUtils {
    static final UUID ZERO_LOCK_TOKEN = new UUID(0L, 0L);
    static final int LOCK_TOKEN_SIZE = 16;
    private static final Symbol DEAD_LETTER_OPERATION = Symbol.getSymbol((String)"com.microsoft:dead-letter");
    private static final String DEAD_LETTER_REASON = "DeadLetterReason";
    private static final String DEAD_LETTER_ERROR_DESCRIPTION = "DeadLetterErrorDescription";
    private static final long EPOCH_IN_DOT_NET_TICKS = 621355968000000000L;
    private static final int GUID_SIZE = 16;

    private MessageUtils() {
    }

    public static Duration adjustServerTimeout(Duration clientTimeout) {
        return clientTimeout.minusMillis(1000L);
    }

    public static Duration getTotalTimeout(AmqpRetryOptions retryOptions) {
        long tryTimeout = retryOptions.getTryTimeout().toNanos();
        long maxDelay = retryOptions.getMaxDelay().toNanos();
        long totalTimeout = tryTimeout;
        if (retryOptions.getMode() == AmqpRetryMode.FIXED) {
            totalTimeout += (retryOptions.getDelay().toNanos() + tryTimeout) * (long)retryOptions.getMaxRetries();
        } else {
            int multiplier = 1;
            for (int i = 0; i < retryOptions.getMaxRetries(); ++i) {
                long retryDelay = retryOptions.getDelay().toNanos() * (long)multiplier;
                if (retryDelay >= maxDelay) {
                    retryDelay = maxDelay;
                    totalTimeout += (tryTimeout + retryDelay) * (long)(retryOptions.getMaxRetries() - i);
                    break;
                }
                multiplier *= 2;
                totalTimeout += tryTimeout + retryDelay;
            }
        }
        return Duration.ofNanos(totalTimeout);
    }

    public static <T> Disposable subscribe(Mono<T> source) {
        return source.subscribe((T ignored) -> {}, (T e) -> {}, () -> {});
    }

    public static <T> Disposable subscribe(Flux<T> source) {
        return source.subscribe((T ignored) -> {}, (T e) -> {}, () -> {});
    }

    public static <T> Disposable subscribe(Mono<T> source, String message, LoggingEventBuilder logger) {
        return source.subscribe((T ignored) -> {}, (T e) -> logger.log(message + " (terminal-error)", new Object[]{e}), () -> logger.log(message + " (terminal-completion)"));
    }

    static UUID convertDotNetBytesToUUID(byte[] dotNetBytes) {
        if (dotNetBytes == null || dotNetBytes.length != 16) {
            return ZERO_LOCK_TOKEN;
        }
        byte[] reOrderedBytes = MessageUtils.reorderBytes(dotNetBytes);
        ByteBuffer buffer = ByteBuffer.wrap(reOrderedBytes);
        long mostSignificantBits = buffer.getLong();
        long leastSignificantBits = buffer.getLong();
        return new UUID(mostSignificantBits, leastSignificantBits);
    }

    static byte[] convertUUIDToDotNetBytes(UUID uuid) {
        if (uuid == null || uuid.equals(ZERO_LOCK_TOKEN)) {
            return new byte[16];
        }
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        byte[] javaBytes = buffer.array();
        return MessageUtils.reorderBytes(javaBytes);
    }

    static OffsetDateTime convertDotNetTicksToOffsetDateTime(long dotNetTicks) {
        long ticksFromEpoch = dotNetTicks - 621355968000000000L;
        long millisecondsFromEpoch = Double.valueOf((double)ticksFromEpoch * 1.0E-4).longValue();
        long fractionTicks = ticksFromEpoch % 10000L;
        return Instant.ofEpochMilli(millisecondsFromEpoch).plusNanos(fractionTicks * 100L).atOffset(ZoneOffset.UTC);
    }

    public static DeliveryState getDeliveryState(DispositionStatus dispositionStatus, String deadLetterReason, String deadLetterErrorDescription, Map<String, Object> propertiesToModify, ServiceBusTransactionContext transactionContext) {
        Released state;
        boolean hasTransaction = transactionContext != null && transactionContext.getTransactionId() != null;
        switch (dispositionStatus) {
            case COMPLETED: {
                if (hasTransaction) {
                    state = MessageUtils.getTransactionState(transactionContext.getTransactionId(), (Outcome)Accepted.getInstance());
                    break;
                }
                state = Accepted.getInstance();
                break;
            }
            case SUSPENDED: {
                Rejected rejected = new Rejected();
                ErrorCondition error = new ErrorCondition(DEAD_LETTER_OPERATION, null);
                HashMap<String, Object> errorInfo = new HashMap<String, Object>();
                if (!CoreUtils.isNullOrEmpty((CharSequence)deadLetterReason)) {
                    errorInfo.put(DEAD_LETTER_REASON, deadLetterReason);
                }
                if (!CoreUtils.isNullOrEmpty((CharSequence)deadLetterErrorDescription)) {
                    errorInfo.put(DEAD_LETTER_ERROR_DESCRIPTION, deadLetterErrorDescription);
                }
                if (propertiesToModify != null) {
                    errorInfo.putAll(propertiesToModify);
                }
                error.setInfo(errorInfo);
                rejected.setError(error);
                if (hasTransaction) {
                    state = MessageUtils.getTransactionState(transactionContext.getTransactionId(), (Outcome)rejected);
                    break;
                }
                state = rejected;
                break;
            }
            case ABANDONED: {
                Modified outcome = new Modified();
                if (propertiesToModify != null) {
                    outcome.setMessageAnnotations(propertiesToModify);
                }
                if (hasTransaction) {
                    state = MessageUtils.getTransactionState(transactionContext.getTransactionId(), (Outcome)outcome);
                    break;
                }
                state = outcome;
                break;
            }
            case DEFERRED: {
                Modified deferredOutcome = new Modified();
                deferredOutcome.setUndeliverableHere(Boolean.valueOf(true));
                if (propertiesToModify != null) {
                    deferredOutcome.setMessageAnnotations(propertiesToModify);
                }
                if (hasTransaction) {
                    state = MessageUtils.getTransactionState(transactionContext.getTransactionId(), (Outcome)deferredOutcome);
                    break;
                }
                state = deferredOutcome;
                break;
            }
            case RELEASED: {
                state = Released.getInstance();
                break;
            }
            default: {
                state = null;
            }
        }
        return state;
    }

    public static boolean toPrimitive(Boolean value) {
        return value != null ? value : false;
    }

    public static int toPrimitive(Integer value) {
        return value != null ? value : 0;
    }

    public static long toPrimitive(Long value) {
        return value != null ? value : 0L;
    }

    private static byte[] reorderBytes(byte[] javaBytes) {
        byte[] reorderedBytes = new byte[16];
        for (int i = 0; i < 16; ++i) {
            switch (i) {
                case 0: {
                    int indexInReorderedBytes = 3;
                    break;
                }
                case 1: {
                    int indexInReorderedBytes = 2;
                    break;
                }
                case 2: {
                    int indexInReorderedBytes = 1;
                    break;
                }
                case 3: {
                    int indexInReorderedBytes = 0;
                    break;
                }
                case 4: {
                    int indexInReorderedBytes = 5;
                    break;
                }
                case 5: {
                    int indexInReorderedBytes = 4;
                    break;
                }
                case 6: {
                    int indexInReorderedBytes = 7;
                    break;
                }
                case 7: {
                    int indexInReorderedBytes = 6;
                    break;
                }
                default: {
                    int indexInReorderedBytes = i;
                }
            }
            reorderedBytes[indexInReorderedBytes] = javaBytes[i];
        }
        return reorderedBytes;
    }

    private static TransactionalState getTransactionState(ByteBuffer transactionId, Outcome outcome) {
        TransactionalState transactionalState = new TransactionalState();
        transactionalState.setTxnId(Binary.create((ByteBuffer)transactionId));
        transactionalState.setOutcome(outcome);
        return transactionalState;
    }

    public static <T> T describedToOrigin(DescribedType describedType) {
        Object descriptor = describedType.getDescriptor();
        Object described = describedType.getDescribed();
        Objects.requireNonNull(descriptor, "descriptor of described type cannot be null.");
        Objects.requireNonNull(described, "described of described type cannot be null.");
        if (ServiceBusConstants.URI_SYMBOL.equals(descriptor)) {
            try {
                return (T)URI.create((String)described);
            }
            catch (IllegalArgumentException ex) {
                return (T)described;
            }
        }
        if (ServiceBusConstants.OFFSETDATETIME_SYMBOL.equals(descriptor)) {
            long tickTime = (Long)described - ServiceBusConstants.EPOCH_TICKS;
            int nano = (int)(tickTime % ServiceBusConstants.TICK_PER_SECOND * ServiceBusConstants.TIME_LENGTH_DELTA);
            long seconds = tickTime / ServiceBusConstants.TICK_PER_SECOND;
            return (T)OffsetDateTime.ofInstant(Instant.ofEpochSecond(seconds, nano), ZoneOffset.UTC);
        }
        if (ServiceBusConstants.DURATION_SYMBOL.equals(descriptor)) {
            return (T)Duration.ofNanos((Long)described * ServiceBusConstants.TIME_LENGTH_DELTA);
        }
        return (T)described;
    }

    public static Map<String, Object> encodeRuleOptionToMap(String name, CreateRuleOptions options) {
        HashMap<String, Object> descriptionMap = new HashMap<String, Object>(3);
        if (options.getFilter() instanceof SqlRuleFilter) {
            HashMap<String, String> filterMap = new HashMap<String, String>(1);
            filterMap.put("expression", ((SqlRuleFilter)options.getFilter()).getSqlExpression());
            descriptionMap.put("sql-filter", filterMap);
        } else if (options.getFilter() instanceof CorrelationRuleFilter) {
            CorrelationRuleFilter correlationFilter = (CorrelationRuleFilter)options.getFilter();
            HashMap<String, Object> filterMap = new HashMap<String, Object>(9);
            filterMap.put("correlation-id", correlationFilter.getCorrelationId());
            filterMap.put("message-id", correlationFilter.getMessageId());
            filterMap.put("to", correlationFilter.getTo());
            filterMap.put("reply-to", correlationFilter.getReplyTo());
            filterMap.put("label", correlationFilter.getLabel());
            filterMap.put("session-id", correlationFilter.getSessionId());
            filterMap.put("reply-to-session-id", correlationFilter.getReplyToSessionId());
            filterMap.put("content-type", correlationFilter.getContentType());
            filterMap.put("properties", correlationFilter.getProperties());
            descriptionMap.put("correlation-filter", filterMap);
        } else {
            throw new IllegalArgumentException("This API supports the addition of only SQLFilters and CorrelationFilters.");
        }
        RuleAction action = options.getAction();
        if (action == null) {
            descriptionMap.put("sql-rule-action", null);
        } else if (action instanceof SqlRuleAction) {
            HashMap<String, String> sqlActionMap = new HashMap<String, String>(1);
            sqlActionMap.put("expression", ((SqlRuleAction)action).getSqlExpression());
            descriptionMap.put("sql-rule-action", sqlActionMap);
        } else {
            throw new IllegalArgumentException("This API supports the addition of only filters with SqlRuleActions.");
        }
        descriptionMap.put("rule-name", name);
        return descriptionMap;
    }

    public static RuleProperties decodeRuleDescribedType(DescribedType ruleDescribedType) {
        if (ruleDescribedType == null) {
            return null;
        }
        if (!ruleDescribedType.getDescriptor().equals(ServiceBusConstants.RULE_DESCRIPTION_NAME)) {
            return null;
        }
        RuleDescription ruleDescription = new RuleDescription();
        if (ruleDescribedType.getDescribed() instanceof Iterable) {
            Iterator describedRule = ((Iterable)ruleDescribedType.getDescribed()).iterator();
            if (describedRule.hasNext()) {
                RuleFilter ruleFilter = MessageUtils.decodeFilter((DescribedType)describedRule.next());
                ruleDescription.setFilter(Objects.isNull(ruleFilter) ? null : EntityHelper.toImplementation(ruleFilter));
            }
            if (describedRule.hasNext()) {
                RuleAction ruleAction = MessageUtils.decodeRuleAction((DescribedType)describedRule.next());
                ruleDescription.setAction(Objects.isNull(ruleAction) ? null : EntityHelper.toImplementation(ruleAction));
            }
            if (describedRule.hasNext()) {
                ruleDescription.setName((String)describedRule.next());
            }
        }
        return EntityHelper.toModel(ruleDescription);
    }

    private static RuleFilter decodeFilter(DescribedType describedFilter) {
        if (describedFilter.getDescriptor().equals(ServiceBusConstants.SQL_FILTER_NAME) && describedFilter.getDescribed() instanceof Iterable) {
            Iterator describedSqlFilter = ((Iterable)describedFilter.getDescribed()).iterator();
            if (describedSqlFilter.hasNext()) {
                return new SqlRuleFilter((String)describedSqlFilter.next());
            }
        } else {
            if (describedFilter.getDescriptor().equals(ServiceBusConstants.CORRELATION_FILTER_NAME) && describedFilter.getDescribed() instanceof Iterable) {
                Object properties;
                CorrelationRuleFilter correlationFilter = new CorrelationRuleFilter();
                Iterator describedCorrelationFilter = ((Iterable)describedFilter.getDescribed()).iterator();
                if (describedCorrelationFilter.hasNext()) {
                    correlationFilter.setCorrelationId((String)describedCorrelationFilter.next());
                }
                if (describedCorrelationFilter.hasNext()) {
                    correlationFilter.setMessageId((String)describedCorrelationFilter.next());
                }
                if (describedCorrelationFilter.hasNext()) {
                    correlationFilter.setTo((String)describedCorrelationFilter.next());
                }
                if (describedCorrelationFilter.hasNext()) {
                    correlationFilter.setReplyTo((String)describedCorrelationFilter.next());
                }
                if (describedCorrelationFilter.hasNext()) {
                    correlationFilter.setLabel((String)describedCorrelationFilter.next());
                }
                if (describedCorrelationFilter.hasNext()) {
                    correlationFilter.setSessionId((String)describedCorrelationFilter.next());
                }
                if (describedCorrelationFilter.hasNext()) {
                    correlationFilter.setReplyToSessionId((String)describedCorrelationFilter.next());
                }
                if (describedCorrelationFilter.hasNext()) {
                    correlationFilter.setContentType((String)describedCorrelationFilter.next());
                }
                if (describedCorrelationFilter.hasNext() && (properties = describedCorrelationFilter.next()) instanceof Map) {
                    correlationFilter.getProperties().putAll((Map)properties);
                }
                return correlationFilter;
            }
            if (describedFilter.getDescriptor().equals(ServiceBusConstants.TRUE_FILTER_NAME)) {
                return new TrueRuleFilter();
            }
            if (describedFilter.getDescriptor().equals(ServiceBusConstants.FALSE_FILTER_NAME)) {
                return new FalseRuleFilter();
            }
            throw new UnsupportedOperationException("This client cannot support filter with descriptor: " + describedFilter.getDescriptor());
        }
        return null;
    }

    private static RuleAction decodeRuleAction(DescribedType describedAction) {
        Iterator describedSqlAction;
        if (describedAction.getDescriptor().equals(ServiceBusConstants.EMPTY_RULE_ACTION_NAME)) {
            return null;
        }
        if (describedAction.getDescriptor().equals(ServiceBusConstants.SQL_RULE_ACTION_NAME) && describedAction.getDescribed() instanceof Iterable && (describedSqlAction = ((Iterable)describedAction.getDescribed()).iterator()).hasNext()) {
            return new SqlRuleAction((String)describedSqlAction.next());
        }
        return null;
    }
}

