/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.core.util.Context;
import com.azure.security.keyvault.keys.cryptography.CryptographyServiceClient;
import com.azure.security.keyvault.keys.cryptography.models.DecryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.KeyWrapAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.SignResult;
import com.azure.security.keyvault.keys.cryptography.models.SignatureAlgorithm;
import com.azure.security.keyvault.keys.cryptography.models.UnwrapResult;
import com.azure.security.keyvault.keys.cryptography.models.VerifyResult;
import com.azure.security.keyvault.keys.cryptography.models.WrapResult;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import reactor.core.publisher.Mono;

abstract class LocalKeyCryptographyClient {
    final CryptographyServiceClient serviceClient;

    LocalKeyCryptographyClient(CryptographyServiceClient serviceClient) {
        this.serviceClient = serviceClient;
    }

    LocalKeyCryptographyClient(JsonWebKey key, CryptographyServiceClient serviceClient) {
        this.serviceClient = serviceClient;
    }

    abstract Mono<EncryptResult> encryptAsync(EncryptionAlgorithm var1, byte[] var2, Context var3, JsonWebKey var4);

    abstract Mono<DecryptResult> decryptAsync(EncryptionAlgorithm var1, byte[] var2, Context var3, JsonWebKey var4);

    abstract Mono<SignResult> signAsync(SignatureAlgorithm var1, byte[] var2, Context var3, JsonWebKey var4);

    abstract Mono<VerifyResult> verifyAsync(SignatureAlgorithm var1, byte[] var2, byte[] var3, Context var4, JsonWebKey var5);

    abstract Mono<WrapResult> wrapKeyAsync(KeyWrapAlgorithm var1, byte[] var2, Context var3, JsonWebKey var4);

    abstract Mono<UnwrapResult> unwrapKeyAsync(KeyWrapAlgorithm var1, byte[] var2, Context var3, JsonWebKey var4);

    abstract Mono<SignResult> signDataAsync(SignatureAlgorithm var1, byte[] var2, Context var3, JsonWebKey var4);

    abstract Mono<VerifyResult> verifyDataAsync(SignatureAlgorithm var1, byte[] var2, byte[] var3, Context var4, JsonWebKey var5);
}

