/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.models;

import com.azure.core.util.BinaryData;
import com.azure.core.util.DateTimeRfc1123;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;

@JacksonXmlRootElement(localName="QueueMessage")
public final class QueueMessageItem {
    @JsonProperty(value="MessageId", required=true)
    private String messageId;
    @JsonProperty(value="InsertionTime", required=true)
    private DateTimeRfc1123 insertionTime;
    @JsonProperty(value="ExpirationTime", required=true)
    private DateTimeRfc1123 expirationTime;
    @JsonProperty(value="PopReceipt", required=true)
    private String popReceipt;
    @JsonProperty(value="TimeNextVisible", required=true)
    private DateTimeRfc1123 timeNextVisible;
    @JsonProperty(value="DequeueCount", required=true)
    private long dequeueCount;
    private BinaryData body;

    public String getMessageId() {
        return this.messageId;
    }

    public QueueMessageItem setMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    public OffsetDateTime getInsertionTime() {
        if (this.insertionTime == null) {
            return null;
        }
        return this.insertionTime.getDateTime();
    }

    public QueueMessageItem setInsertionTime(OffsetDateTime insertionTime) {
        this.insertionTime = insertionTime == null ? null : new DateTimeRfc1123(insertionTime);
        return this;
    }

    public OffsetDateTime getExpirationTime() {
        if (this.expirationTime == null) {
            return null;
        }
        return this.expirationTime.getDateTime();
    }

    public QueueMessageItem setExpirationTime(OffsetDateTime expirationTime) {
        this.expirationTime = expirationTime == null ? null : new DateTimeRfc1123(expirationTime);
        return this;
    }

    public String getPopReceipt() {
        return this.popReceipt;
    }

    public QueueMessageItem setPopReceipt(String popReceipt) {
        this.popReceipt = popReceipt;
        return this;
    }

    public OffsetDateTime getTimeNextVisible() {
        if (this.timeNextVisible == null) {
            return null;
        }
        return this.timeNextVisible.getDateTime();
    }

    public QueueMessageItem setTimeNextVisible(OffsetDateTime timeNextVisible) {
        this.timeNextVisible = timeNextVisible == null ? null : new DateTimeRfc1123(timeNextVisible);
        return this;
    }

    public long getDequeueCount() {
        return this.dequeueCount;
    }

    public QueueMessageItem setDequeueCount(long dequeueCount) {
        this.dequeueCount = dequeueCount;
        return this;
    }

    @Deprecated
    public String getMessageText() {
        return this.body == null ? null : this.body.toString();
    }

    @Deprecated
    public QueueMessageItem setMessageText(String messageText) {
        this.body = messageText == null ? null : BinaryData.fromString((String)messageText);
        return this;
    }

    public BinaryData getBody() {
        return this.body;
    }

    public QueueMessageItem setBody(BinaryData body) {
        this.body = body;
        return this;
    }
}

