/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.AppServiceEnvironmentInner;
import com.azure.resourcemanager.appservice.fluent.models.AseV3NetworkingConfigurationInner;
import com.azure.resourcemanager.appservice.fluent.models.CustomDnsSuffixConfigurationInner;
import com.azure.resourcemanager.appservice.models.HostingEnvironmentStatus;
import com.azure.resourcemanager.appservice.models.LoadBalancingMode;
import com.azure.resourcemanager.appservice.models.NameValuePair;
import com.azure.resourcemanager.appservice.models.ProvisioningState;
import com.azure.resourcemanager.appservice.models.UpgradeAvailability;
import com.azure.resourcemanager.appservice.models.UpgradePreference;
import com.azure.resourcemanager.appservice.models.VirtualNetworkProfile;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class AppServiceEnvironmentResourceInner
extends Resource {
    private AppServiceEnvironmentInner innerProperties;
    private String kind;
    private String id;
    private String name;
    private String type;

    private AppServiceEnvironmentInner innerProperties() {
        return this.innerProperties;
    }

    public String kind() {
        return this.kind;
    }

    public AppServiceEnvironmentResourceInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public AppServiceEnvironmentResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public AppServiceEnvironmentResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public HostingEnvironmentStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public VirtualNetworkProfile virtualNetwork() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetwork();
    }

    public AppServiceEnvironmentResourceInner withVirtualNetwork(VirtualNetworkProfile virtualNetwork) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withVirtualNetwork(virtualNetwork);
        return this;
    }

    public LoadBalancingMode internalLoadBalancingMode() {
        return this.innerProperties() == null ? null : this.innerProperties().internalLoadBalancingMode();
    }

    public AppServiceEnvironmentResourceInner withInternalLoadBalancingMode(LoadBalancingMode internalLoadBalancingMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withInternalLoadBalancingMode(internalLoadBalancingMode);
        return this;
    }

    public String multiSize() {
        return this.innerProperties() == null ? null : this.innerProperties().multiSize();
    }

    public AppServiceEnvironmentResourceInner withMultiSize(String multiSize) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withMultiSize(multiSize);
        return this;
    }

    public Integer multiRoleCount() {
        return this.innerProperties() == null ? null : this.innerProperties().multiRoleCount();
    }

    public Integer ipsslAddressCount() {
        return this.innerProperties() == null ? null : this.innerProperties().ipsslAddressCount();
    }

    public AppServiceEnvironmentResourceInner withIpsslAddressCount(Integer ipsslAddressCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withIpsslAddressCount(ipsslAddressCount);
        return this;
    }

    public String dnsSuffix() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsSuffix();
    }

    public AppServiceEnvironmentResourceInner withDnsSuffix(String dnsSuffix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withDnsSuffix(dnsSuffix);
        return this;
    }

    public Integer maximumNumberOfMachines() {
        return this.innerProperties() == null ? null : this.innerProperties().maximumNumberOfMachines();
    }

    public Integer frontEndScaleFactor() {
        return this.innerProperties() == null ? null : this.innerProperties().frontEndScaleFactor();
    }

    public AppServiceEnvironmentResourceInner withFrontEndScaleFactor(Integer frontEndScaleFactor) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withFrontEndScaleFactor(frontEndScaleFactor);
        return this;
    }

    public Boolean suspended() {
        return this.innerProperties() == null ? null : this.innerProperties().suspended();
    }

    public List<NameValuePair> clusterSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterSettings();
    }

    public AppServiceEnvironmentResourceInner withClusterSettings(List<NameValuePair> clusterSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withClusterSettings(clusterSettings);
        return this;
    }

    public List<String> userWhitelistedIpRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().userWhitelistedIpRanges();
    }

    public AppServiceEnvironmentResourceInner withUserWhitelistedIpRanges(List<String> userWhitelistedIpRanges) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withUserWhitelistedIpRanges(userWhitelistedIpRanges);
        return this;
    }

    public Boolean hasLinuxWorkers() {
        return this.innerProperties() == null ? null : this.innerProperties().hasLinuxWorkers();
    }

    public UpgradePreference upgradePreference() {
        return this.innerProperties() == null ? null : this.innerProperties().upgradePreference();
    }

    public AppServiceEnvironmentResourceInner withUpgradePreference(UpgradePreference upgradePreference) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withUpgradePreference(upgradePreference);
        return this;
    }

    public Integer dedicatedHostCount() {
        return this.innerProperties() == null ? null : this.innerProperties().dedicatedHostCount();
    }

    public AppServiceEnvironmentResourceInner withDedicatedHostCount(Integer dedicatedHostCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withDedicatedHostCount(dedicatedHostCount);
        return this;
    }

    public Boolean zoneRedundant() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneRedundant();
    }

    public AppServiceEnvironmentResourceInner withZoneRedundant(Boolean zoneRedundant) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withZoneRedundant(zoneRedundant);
        return this;
    }

    public CustomDnsSuffixConfigurationInner customDnsSuffixConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().customDnsSuffixConfiguration();
    }

    public AppServiceEnvironmentResourceInner withCustomDnsSuffixConfiguration(CustomDnsSuffixConfigurationInner customDnsSuffixConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withCustomDnsSuffixConfiguration(customDnsSuffixConfiguration);
        return this;
    }

    public AseV3NetworkingConfigurationInner networkingConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().networkingConfiguration();
    }

    public AppServiceEnvironmentResourceInner withNetworkingConfiguration(AseV3NetworkingConfigurationInner networkingConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withNetworkingConfiguration(networkingConfiguration);
        return this;
    }

    public UpgradeAvailability upgradeAvailability() {
        return this.innerProperties() == null ? null : this.innerProperties().upgradeAvailability();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("kind", this.kind);
        return jsonWriter.writeEndObject();
    }

    public static AppServiceEnvironmentResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (AppServiceEnvironmentResourceInner)((Object)jsonReader.readObject(reader -> {
            AppServiceEnvironmentResourceInner deserializedAppServiceEnvironmentResourceInner = new AppServiceEnvironmentResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAppServiceEnvironmentResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAppServiceEnvironmentResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAppServiceEnvironmentResourceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedAppServiceEnvironmentResourceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAppServiceEnvironmentResourceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAppServiceEnvironmentResourceInner.innerProperties = AppServiceEnvironmentInner.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedAppServiceEnvironmentResourceInner.kind = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAppServiceEnvironmentResourceInner;
        }));
    }
}

