/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.HostingEnvironmentProfile;
import com.azure.resourcemanager.appservice.models.KubeEnvironmentProfile;
import com.azure.resourcemanager.appservice.models.ProvisioningState;
import com.azure.resourcemanager.appservice.models.StatusOptions;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class AppServicePlanProperties
implements JsonSerializable<AppServicePlanProperties> {
    private String workerTierName;
    private StatusOptions status;
    private String subscription;
    private HostingEnvironmentProfile hostingEnvironmentProfile;
    private Integer maximumNumberOfWorkers;
    private Integer numberOfWorkers;
    private String geoRegion;
    private Boolean perSiteScaling;
    private Boolean elasticScaleEnabled;
    private Integer maximumElasticWorkerCount;
    private Integer numberOfSites;
    private Boolean isSpot;
    private OffsetDateTime spotExpirationTime;
    private OffsetDateTime freeOfferExpirationTime;
    private String resourceGroup;
    private Boolean reserved;
    private Boolean isXenon;
    private Boolean hyperV;
    private Integer targetWorkerCount;
    private Integer targetWorkerSizeId;
    private ProvisioningState provisioningState;
    private KubeEnvironmentProfile kubeEnvironmentProfile;
    private Boolean zoneRedundant;

    public String workerTierName() {
        return this.workerTierName;
    }

    public AppServicePlanProperties withWorkerTierName(String workerTierName) {
        this.workerTierName = workerTierName;
        return this;
    }

    public StatusOptions status() {
        return this.status;
    }

    public String subscription() {
        return this.subscription;
    }

    public HostingEnvironmentProfile hostingEnvironmentProfile() {
        return this.hostingEnvironmentProfile;
    }

    public AppServicePlanProperties withHostingEnvironmentProfile(HostingEnvironmentProfile hostingEnvironmentProfile) {
        this.hostingEnvironmentProfile = hostingEnvironmentProfile;
        return this;
    }

    public Integer maximumNumberOfWorkers() {
        return this.maximumNumberOfWorkers;
    }

    public Integer numberOfWorkers() {
        return this.numberOfWorkers;
    }

    public String geoRegion() {
        return this.geoRegion;
    }

    public Boolean perSiteScaling() {
        return this.perSiteScaling;
    }

    public AppServicePlanProperties withPerSiteScaling(Boolean perSiteScaling) {
        this.perSiteScaling = perSiteScaling;
        return this;
    }

    public Boolean elasticScaleEnabled() {
        return this.elasticScaleEnabled;
    }

    public AppServicePlanProperties withElasticScaleEnabled(Boolean elasticScaleEnabled) {
        this.elasticScaleEnabled = elasticScaleEnabled;
        return this;
    }

    public Integer maximumElasticWorkerCount() {
        return this.maximumElasticWorkerCount;
    }

    public AppServicePlanProperties withMaximumElasticWorkerCount(Integer maximumElasticWorkerCount) {
        this.maximumElasticWorkerCount = maximumElasticWorkerCount;
        return this;
    }

    public Integer numberOfSites() {
        return this.numberOfSites;
    }

    public Boolean isSpot() {
        return this.isSpot;
    }

    public AppServicePlanProperties withIsSpot(Boolean isSpot) {
        this.isSpot = isSpot;
        return this;
    }

    public OffsetDateTime spotExpirationTime() {
        return this.spotExpirationTime;
    }

    public AppServicePlanProperties withSpotExpirationTime(OffsetDateTime spotExpirationTime) {
        this.spotExpirationTime = spotExpirationTime;
        return this;
    }

    public OffsetDateTime freeOfferExpirationTime() {
        return this.freeOfferExpirationTime;
    }

    public AppServicePlanProperties withFreeOfferExpirationTime(OffsetDateTime freeOfferExpirationTime) {
        this.freeOfferExpirationTime = freeOfferExpirationTime;
        return this;
    }

    public String resourceGroup() {
        return this.resourceGroup;
    }

    public Boolean reserved() {
        return this.reserved;
    }

    public AppServicePlanProperties withReserved(Boolean reserved) {
        this.reserved = reserved;
        return this;
    }

    public Boolean isXenon() {
        return this.isXenon;
    }

    public AppServicePlanProperties withIsXenon(Boolean isXenon) {
        this.isXenon = isXenon;
        return this;
    }

    public Boolean hyperV() {
        return this.hyperV;
    }

    public AppServicePlanProperties withHyperV(Boolean hyperV) {
        this.hyperV = hyperV;
        return this;
    }

    public Integer targetWorkerCount() {
        return this.targetWorkerCount;
    }

    public AppServicePlanProperties withTargetWorkerCount(Integer targetWorkerCount) {
        this.targetWorkerCount = targetWorkerCount;
        return this;
    }

    public Integer targetWorkerSizeId() {
        return this.targetWorkerSizeId;
    }

    public AppServicePlanProperties withTargetWorkerSizeId(Integer targetWorkerSizeId) {
        this.targetWorkerSizeId = targetWorkerSizeId;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public KubeEnvironmentProfile kubeEnvironmentProfile() {
        return this.kubeEnvironmentProfile;
    }

    public AppServicePlanProperties withKubeEnvironmentProfile(KubeEnvironmentProfile kubeEnvironmentProfile) {
        this.kubeEnvironmentProfile = kubeEnvironmentProfile;
        return this;
    }

    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    public AppServicePlanProperties withZoneRedundant(Boolean zoneRedundant) {
        this.zoneRedundant = zoneRedundant;
        return this;
    }

    public void validate() {
        if (this.hostingEnvironmentProfile() != null) {
            this.hostingEnvironmentProfile().validate();
        }
        if (this.kubeEnvironmentProfile() != null) {
            this.kubeEnvironmentProfile().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("workerTierName", this.workerTierName);
        jsonWriter.writeJsonField("hostingEnvironmentProfile", (JsonSerializable)this.hostingEnvironmentProfile);
        jsonWriter.writeBooleanField("perSiteScaling", this.perSiteScaling);
        jsonWriter.writeBooleanField("elasticScaleEnabled", this.elasticScaleEnabled);
        jsonWriter.writeNumberField("maximumElasticWorkerCount", (Number)this.maximumElasticWorkerCount);
        jsonWriter.writeBooleanField("isSpot", this.isSpot);
        jsonWriter.writeStringField("spotExpirationTime", this.spotExpirationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.spotExpirationTime));
        jsonWriter.writeStringField("freeOfferExpirationTime", this.freeOfferExpirationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.freeOfferExpirationTime));
        jsonWriter.writeBooleanField("reserved", this.reserved);
        jsonWriter.writeBooleanField("isXenon", this.isXenon);
        jsonWriter.writeBooleanField("hyperV", this.hyperV);
        jsonWriter.writeNumberField("targetWorkerCount", (Number)this.targetWorkerCount);
        jsonWriter.writeNumberField("targetWorkerSizeId", (Number)this.targetWorkerSizeId);
        jsonWriter.writeJsonField("kubeEnvironmentProfile", (JsonSerializable)this.kubeEnvironmentProfile);
        jsonWriter.writeBooleanField("zoneRedundant", this.zoneRedundant);
        return jsonWriter.writeEndObject();
    }

    public static AppServicePlanProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AppServicePlanProperties)jsonReader.readObject(reader -> {
            AppServicePlanProperties deserializedAppServicePlanProperties = new AppServicePlanProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("workerTierName".equals(fieldName)) {
                    deserializedAppServicePlanProperties.workerTierName = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedAppServicePlanProperties.status = StatusOptions.fromString(reader.getString());
                    continue;
                }
                if ("subscription".equals(fieldName)) {
                    deserializedAppServicePlanProperties.subscription = reader.getString();
                    continue;
                }
                if ("hostingEnvironmentProfile".equals(fieldName)) {
                    deserializedAppServicePlanProperties.hostingEnvironmentProfile = HostingEnvironmentProfile.fromJson(reader);
                    continue;
                }
                if ("maximumNumberOfWorkers".equals(fieldName)) {
                    deserializedAppServicePlanProperties.maximumNumberOfWorkers = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("numberOfWorkers".equals(fieldName)) {
                    deserializedAppServicePlanProperties.numberOfWorkers = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("geoRegion".equals(fieldName)) {
                    deserializedAppServicePlanProperties.geoRegion = reader.getString();
                    continue;
                }
                if ("perSiteScaling".equals(fieldName)) {
                    deserializedAppServicePlanProperties.perSiteScaling = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("elasticScaleEnabled".equals(fieldName)) {
                    deserializedAppServicePlanProperties.elasticScaleEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("maximumElasticWorkerCount".equals(fieldName)) {
                    deserializedAppServicePlanProperties.maximumElasticWorkerCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("numberOfSites".equals(fieldName)) {
                    deserializedAppServicePlanProperties.numberOfSites = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("isSpot".equals(fieldName)) {
                    deserializedAppServicePlanProperties.isSpot = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("spotExpirationTime".equals(fieldName)) {
                    deserializedAppServicePlanProperties.spotExpirationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("freeOfferExpirationTime".equals(fieldName)) {
                    deserializedAppServicePlanProperties.freeOfferExpirationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("resourceGroup".equals(fieldName)) {
                    deserializedAppServicePlanProperties.resourceGroup = reader.getString();
                    continue;
                }
                if ("reserved".equals(fieldName)) {
                    deserializedAppServicePlanProperties.reserved = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isXenon".equals(fieldName)) {
                    deserializedAppServicePlanProperties.isXenon = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("hyperV".equals(fieldName)) {
                    deserializedAppServicePlanProperties.hyperV = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("targetWorkerCount".equals(fieldName)) {
                    deserializedAppServicePlanProperties.targetWorkerCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("targetWorkerSizeId".equals(fieldName)) {
                    deserializedAppServicePlanProperties.targetWorkerSizeId = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedAppServicePlanProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("kubeEnvironmentProfile".equals(fieldName)) {
                    deserializedAppServicePlanProperties.kubeEnvironmentProfile = KubeEnvironmentProfile.fromJson(reader);
                    continue;
                }
                if ("zoneRedundant".equals(fieldName)) {
                    deserializedAppServicePlanProperties.zoneRedundant = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAppServicePlanProperties;
        });
    }
}

