/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.DetectorDefinition;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

public final class DetectorDefinitionResourceInner
extends ProxyOnlyResource {
    private DetectorDefinition innerProperties;
    private String id;
    private String name;
    private String type;

    private DetectorDefinition innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public DetectorDefinitionResourceInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public Double rank() {
        return this.innerProperties() == null ? null : this.innerProperties().rank();
    }

    public Boolean isEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isEnabled();
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DetectorDefinitionResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (DetectorDefinitionResourceInner)((Object)jsonReader.readObject(reader -> {
            DetectorDefinitionResourceInner deserializedDetectorDefinitionResourceInner = new DetectorDefinitionResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDetectorDefinitionResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDetectorDefinitionResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDetectorDefinitionResourceInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedDetectorDefinitionResourceInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDetectorDefinitionResourceInner.innerProperties = DetectorDefinition.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDetectorDefinitionResourceInner;
        }));
    }
}

