/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.DetectorDefinition;
import com.azure.resourcemanager.appservice.fluent.models.DiagnosticDetectorResponseProperties;
import com.azure.resourcemanager.appservice.models.DetectorAbnormalTimePeriod;
import com.azure.resourcemanager.appservice.models.DiagnosticMetricSet;
import com.azure.resourcemanager.appservice.models.NameValuePair;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.ResponseMetadata;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class DiagnosticDetectorResponseInner
extends ProxyOnlyResource {
    private DiagnosticDetectorResponseProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private DiagnosticDetectorResponseProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public DiagnosticDetectorResponseInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    public DiagnosticDetectorResponseInner withStartTime(OffsetDateTime startTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiagnosticDetectorResponseProperties();
        }
        this.innerProperties().withStartTime(startTime);
        return this;
    }

    public OffsetDateTime endTime() {
        return this.innerProperties() == null ? null : this.innerProperties().endTime();
    }

    public DiagnosticDetectorResponseInner withEndTime(OffsetDateTime endTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiagnosticDetectorResponseProperties();
        }
        this.innerProperties().withEndTime(endTime);
        return this;
    }

    public Boolean issueDetected() {
        return this.innerProperties() == null ? null : this.innerProperties().issueDetected();
    }

    public DiagnosticDetectorResponseInner withIssueDetected(Boolean issueDetected) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiagnosticDetectorResponseProperties();
        }
        this.innerProperties().withIssueDetected(issueDetected);
        return this;
    }

    public DetectorDefinition detectorDefinition() {
        return this.innerProperties() == null ? null : this.innerProperties().detectorDefinition();
    }

    public DiagnosticDetectorResponseInner withDetectorDefinition(DetectorDefinition detectorDefinition) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiagnosticDetectorResponseProperties();
        }
        this.innerProperties().withDetectorDefinition(detectorDefinition);
        return this;
    }

    public List<DiagnosticMetricSet> metrics() {
        return this.innerProperties() == null ? null : this.innerProperties().metrics();
    }

    public DiagnosticDetectorResponseInner withMetrics(List<DiagnosticMetricSet> metrics) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiagnosticDetectorResponseProperties();
        }
        this.innerProperties().withMetrics(metrics);
        return this;
    }

    public List<DetectorAbnormalTimePeriod> abnormalTimePeriods() {
        return this.innerProperties() == null ? null : this.innerProperties().abnormalTimePeriods();
    }

    public DiagnosticDetectorResponseInner withAbnormalTimePeriods(List<DetectorAbnormalTimePeriod> abnormalTimePeriods) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiagnosticDetectorResponseProperties();
        }
        this.innerProperties().withAbnormalTimePeriods(abnormalTimePeriods);
        return this;
    }

    public List<List<NameValuePair>> data() {
        return this.innerProperties() == null ? null : this.innerProperties().data();
    }

    public DiagnosticDetectorResponseInner withData(List<List<NameValuePair>> data) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiagnosticDetectorResponseProperties();
        }
        this.innerProperties().withData(data);
        return this;
    }

    public ResponseMetadata responseMetadata() {
        return this.innerProperties() == null ? null : this.innerProperties().responseMetadata();
    }

    public DiagnosticDetectorResponseInner withResponseMetadata(ResponseMetadata responseMetadata) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiagnosticDetectorResponseProperties();
        }
        this.innerProperties().withResponseMetadata(responseMetadata);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DiagnosticDetectorResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return (DiagnosticDetectorResponseInner)((Object)jsonReader.readObject(reader -> {
            DiagnosticDetectorResponseInner deserializedDiagnosticDetectorResponseInner = new DiagnosticDetectorResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDiagnosticDetectorResponseInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDiagnosticDetectorResponseInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDiagnosticDetectorResponseInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedDiagnosticDetectorResponseInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDiagnosticDetectorResponseInner.innerProperties = DiagnosticDetectorResponseProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiagnosticDetectorResponseInner;
        }));
    }
}

