/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.DomainProperties;
import com.azure.resourcemanager.appservice.models.Contact;
import com.azure.resourcemanager.appservice.models.DnsType;
import com.azure.resourcemanager.appservice.models.DomainPurchaseConsent;
import com.azure.resourcemanager.appservice.models.DomainStatus;
import com.azure.resourcemanager.appservice.models.Hostname;
import com.azure.resourcemanager.appservice.models.ProvisioningState;
import com.azure.resourcemanager.appservice.models.ResourceNotRenewableReason;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class DomainInner
extends Resource {
    private DomainProperties innerProperties;
    private String kind;
    private String id;
    private String name;
    private String type;

    private DomainProperties innerProperties() {
        return this.innerProperties;
    }

    public String kind() {
        return this.kind;
    }

    public DomainInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public DomainInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public DomainInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public Contact contactAdmin() {
        return this.innerProperties() == null ? null : this.innerProperties().contactAdmin();
    }

    public DomainInner withContactAdmin(Contact contactAdmin) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainProperties();
        }
        this.innerProperties().withContactAdmin(contactAdmin);
        return this;
    }

    public Contact contactBilling() {
        return this.innerProperties() == null ? null : this.innerProperties().contactBilling();
    }

    public DomainInner withContactBilling(Contact contactBilling) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainProperties();
        }
        this.innerProperties().withContactBilling(contactBilling);
        return this;
    }

    public Contact contactRegistrant() {
        return this.innerProperties() == null ? null : this.innerProperties().contactRegistrant();
    }

    public DomainInner withContactRegistrant(Contact contactRegistrant) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainProperties();
        }
        this.innerProperties().withContactRegistrant(contactRegistrant);
        return this;
    }

    public Contact contactTech() {
        return this.innerProperties() == null ? null : this.innerProperties().contactTech();
    }

    public DomainInner withContactTech(Contact contactTech) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainProperties();
        }
        this.innerProperties().withContactTech(contactTech);
        return this;
    }

    public DomainStatus registrationStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().registrationStatus();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public List<String> nameServers() {
        return this.innerProperties() == null ? null : this.innerProperties().nameServers();
    }

    public Boolean privacy() {
        return this.innerProperties() == null ? null : this.innerProperties().privacy();
    }

    public DomainInner withPrivacy(Boolean privacy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainProperties();
        }
        this.innerProperties().withPrivacy(privacy);
        return this;
    }

    public OffsetDateTime createdTime() {
        return this.innerProperties() == null ? null : this.innerProperties().createdTime();
    }

    public OffsetDateTime expirationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().expirationTime();
    }

    public OffsetDateTime lastRenewedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastRenewedTime();
    }

    public Boolean autoRenew() {
        return this.innerProperties() == null ? null : this.innerProperties().autoRenew();
    }

    public DomainInner withAutoRenew(Boolean autoRenew) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainProperties();
        }
        this.innerProperties().withAutoRenew(autoRenew);
        return this;
    }

    public Boolean readyForDnsRecordManagement() {
        return this.innerProperties() == null ? null : this.innerProperties().readyForDnsRecordManagement();
    }

    public List<Hostname> managedHostNames() {
        return this.innerProperties() == null ? null : this.innerProperties().managedHostNames();
    }

    public DomainPurchaseConsent consent() {
        return this.innerProperties() == null ? null : this.innerProperties().consent();
    }

    public DomainInner withConsent(DomainPurchaseConsent consent) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainProperties();
        }
        this.innerProperties().withConsent(consent);
        return this;
    }

    public List<ResourceNotRenewableReason> domainNotRenewableReasons() {
        return this.innerProperties() == null ? null : this.innerProperties().domainNotRenewableReasons();
    }

    public DnsType dnsType() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsType();
    }

    public DomainInner withDnsType(DnsType dnsType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainProperties();
        }
        this.innerProperties().withDnsType(dnsType);
        return this;
    }

    public String dnsZoneId() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsZoneId();
    }

    public DomainInner withDnsZoneId(String dnsZoneId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainProperties();
        }
        this.innerProperties().withDnsZoneId(dnsZoneId);
        return this;
    }

    public DnsType targetDnsType() {
        return this.innerProperties() == null ? null : this.innerProperties().targetDnsType();
    }

    public DomainInner withTargetDnsType(DnsType targetDnsType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainProperties();
        }
        this.innerProperties().withTargetDnsType(targetDnsType);
        return this;
    }

    public String authCode() {
        return this.innerProperties() == null ? null : this.innerProperties().authCode();
    }

    public DomainInner withAuthCode(String authCode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DomainProperties();
        }
        this.innerProperties().withAuthCode(authCode);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("kind", this.kind);
        return jsonWriter.writeEndObject();
    }

    public static DomainInner fromJson(JsonReader jsonReader) throws IOException {
        return (DomainInner)((Object)jsonReader.readObject(reader -> {
            DomainInner deserializedDomainInner = new DomainInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDomainInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDomainInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDomainInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDomainInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDomainInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDomainInner.innerProperties = DomainProperties.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedDomainInner.kind = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDomainInner;
        }));
    }
}

