/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.WebAppStackProperties;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.StackPreferredOs;
import com.azure.resourcemanager.appservice.models.WebAppMajorVersion;
import java.io.IOException;
import java.util.List;

public final class WebAppStackInner
extends ProxyOnlyResource {
    private String location;
    private WebAppStackProperties innerProperties;
    private String id;
    private String name;
    private String type;

    public String location() {
        return this.location;
    }

    private WebAppStackProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public WebAppStackInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String displayText() {
        return this.innerProperties() == null ? null : this.innerProperties().displayText();
    }

    public String value() {
        return this.innerProperties() == null ? null : this.innerProperties().value();
    }

    public List<WebAppMajorVersion> majorVersions() {
        return this.innerProperties() == null ? null : this.innerProperties().majorVersions();
    }

    public StackPreferredOs preferredOs() {
        return this.innerProperties() == null ? null : this.innerProperties().preferredOs();
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static WebAppStackInner fromJson(JsonReader jsonReader) throws IOException {
        return (WebAppStackInner)((Object)jsonReader.readObject(reader -> {
            WebAppStackInner deserializedWebAppStackInner = new WebAppStackInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedWebAppStackInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedWebAppStackInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWebAppStackInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedWebAppStackInner.withKind(reader.getString());
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedWebAppStackInner.location = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedWebAppStackInner.innerProperties = WebAppStackProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebAppStackInner;
        }));
    }
}

