/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.RequestsBasedTrigger;
import com.azure.resourcemanager.appservice.models.SlowRequestsBasedTrigger;
import com.azure.resourcemanager.appservice.models.StatusCodesBasedTrigger;
import com.azure.resourcemanager.appservice.models.StatusCodesRangeBasedTrigger;
import java.io.IOException;
import java.util.List;

public final class AutoHealTriggers
implements JsonSerializable<AutoHealTriggers> {
    private RequestsBasedTrigger requests;
    private Integer privateBytesInKB;
    private List<StatusCodesBasedTrigger> statusCodes;
    private SlowRequestsBasedTrigger slowRequests;
    private List<SlowRequestsBasedTrigger> slowRequestsWithPath;
    private List<StatusCodesRangeBasedTrigger> statusCodesRange;

    public RequestsBasedTrigger requests() {
        return this.requests;
    }

    public AutoHealTriggers withRequests(RequestsBasedTrigger requests) {
        this.requests = requests;
        return this;
    }

    public Integer privateBytesInKB() {
        return this.privateBytesInKB;
    }

    public AutoHealTriggers withPrivateBytesInKB(Integer privateBytesInKB) {
        this.privateBytesInKB = privateBytesInKB;
        return this;
    }

    public List<StatusCodesBasedTrigger> statusCodes() {
        return this.statusCodes;
    }

    public AutoHealTriggers withStatusCodes(List<StatusCodesBasedTrigger> statusCodes) {
        this.statusCodes = statusCodes;
        return this;
    }

    public SlowRequestsBasedTrigger slowRequests() {
        return this.slowRequests;
    }

    public AutoHealTriggers withSlowRequests(SlowRequestsBasedTrigger slowRequests) {
        this.slowRequests = slowRequests;
        return this;
    }

    public List<SlowRequestsBasedTrigger> slowRequestsWithPath() {
        return this.slowRequestsWithPath;
    }

    public AutoHealTriggers withSlowRequestsWithPath(List<SlowRequestsBasedTrigger> slowRequestsWithPath) {
        this.slowRequestsWithPath = slowRequestsWithPath;
        return this;
    }

    public List<StatusCodesRangeBasedTrigger> statusCodesRange() {
        return this.statusCodesRange;
    }

    public AutoHealTriggers withStatusCodesRange(List<StatusCodesRangeBasedTrigger> statusCodesRange) {
        this.statusCodesRange = statusCodesRange;
        return this;
    }

    public void validate() {
        if (this.requests() != null) {
            this.requests().validate();
        }
        if (this.statusCodes() != null) {
            this.statusCodes().forEach(e -> e.validate());
        }
        if (this.slowRequests() != null) {
            this.slowRequests().validate();
        }
        if (this.slowRequestsWithPath() != null) {
            this.slowRequestsWithPath().forEach(e -> e.validate());
        }
        if (this.statusCodesRange() != null) {
            this.statusCodesRange().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("requests", (JsonSerializable)this.requests);
        jsonWriter.writeNumberField("privateBytesInKB", (Number)this.privateBytesInKB);
        jsonWriter.writeArrayField("statusCodes", this.statusCodes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("slowRequests", (JsonSerializable)this.slowRequests);
        jsonWriter.writeArrayField("slowRequestsWithPath", this.slowRequestsWithPath, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("statusCodesRange", this.statusCodesRange, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AutoHealTriggers fromJson(JsonReader jsonReader) throws IOException {
        return (AutoHealTriggers)jsonReader.readObject(reader -> {
            AutoHealTriggers deserializedAutoHealTriggers = new AutoHealTriggers();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("requests".equals(fieldName)) {
                    deserializedAutoHealTriggers.requests = RequestsBasedTrigger.fromJson(reader);
                    continue;
                }
                if ("privateBytesInKB".equals(fieldName)) {
                    deserializedAutoHealTriggers.privateBytesInKB = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("statusCodes".equals(fieldName)) {
                    List statusCodes;
                    deserializedAutoHealTriggers.statusCodes = statusCodes = reader.readArray(reader1 -> StatusCodesBasedTrigger.fromJson(reader1));
                    continue;
                }
                if ("slowRequests".equals(fieldName)) {
                    deserializedAutoHealTriggers.slowRequests = SlowRequestsBasedTrigger.fromJson(reader);
                    continue;
                }
                if ("slowRequestsWithPath".equals(fieldName)) {
                    List slowRequestsWithPath;
                    deserializedAutoHealTriggers.slowRequestsWithPath = slowRequestsWithPath = reader.readArray(reader1 -> SlowRequestsBasedTrigger.fromJson(reader1));
                    continue;
                }
                if ("statusCodesRange".equals(fieldName)) {
                    List statusCodesRange;
                    deserializedAutoHealTriggers.statusCodesRange = statusCodesRange = reader.readArray(reader1 -> StatusCodesRangeBasedTrigger.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutoHealTriggers;
        });
    }
}

