/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.HostType;
import com.azure.resourcemanager.appservice.models.SslState;
import java.io.IOException;

public final class HostnameSslState
implements JsonSerializable<HostnameSslState> {
    private String name;
    private SslState sslState;
    private String virtualIp;
    private String thumbprint;
    private Boolean toUpdate;
    private HostType hostType;

    public String name() {
        return this.name;
    }

    public HostnameSslState withName(String name) {
        this.name = name;
        return this;
    }

    public SslState sslState() {
        return this.sslState;
    }

    public HostnameSslState withSslState(SslState sslState) {
        this.sslState = sslState;
        return this;
    }

    public String virtualIp() {
        return this.virtualIp;
    }

    public HostnameSslState withVirtualIp(String virtualIp) {
        this.virtualIp = virtualIp;
        return this;
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    public HostnameSslState withThumbprint(String thumbprint) {
        this.thumbprint = thumbprint;
        return this;
    }

    public Boolean toUpdate() {
        return this.toUpdate;
    }

    public HostnameSslState withToUpdate(Boolean toUpdate) {
        this.toUpdate = toUpdate;
        return this;
    }

    public HostType hostType() {
        return this.hostType;
    }

    public HostnameSslState withHostType(HostType hostType) {
        this.hostType = hostType;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("sslState", this.sslState == null ? null : this.sslState.toString());
        jsonWriter.writeStringField("virtualIP", this.virtualIp);
        jsonWriter.writeStringField("thumbprint", this.thumbprint);
        jsonWriter.writeBooleanField("toUpdate", this.toUpdate);
        jsonWriter.writeStringField("hostType", this.hostType == null ? null : this.hostType.toString());
        return jsonWriter.writeEndObject();
    }

    public static HostnameSslState fromJson(JsonReader jsonReader) throws IOException {
        return (HostnameSslState)jsonReader.readObject(reader -> {
            HostnameSslState deserializedHostnameSslState = new HostnameSslState();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedHostnameSslState.name = reader.getString();
                    continue;
                }
                if ("sslState".equals(fieldName)) {
                    deserializedHostnameSslState.sslState = SslState.fromString(reader.getString());
                    continue;
                }
                if ("virtualIP".equals(fieldName)) {
                    deserializedHostnameSslState.virtualIp = reader.getString();
                    continue;
                }
                if ("thumbprint".equals(fieldName)) {
                    deserializedHostnameSslState.thumbprint = reader.getString();
                    continue;
                }
                if ("toUpdate".equals(fieldName)) {
                    deserializedHostnameSslState.toUpdate = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("hostType".equals(fieldName)) {
                    deserializedHostnameSslState.hostType = HostType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHostnameSslState;
        });
    }
}

