/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.PremierAddOnPatchResourceProperties;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

public final class PremierAddOnPatchResource
extends ProxyOnlyResource {
    private PremierAddOnPatchResourceProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private PremierAddOnPatchResourceProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public PremierAddOnPatchResource withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String sku() {
        return this.innerProperties() == null ? null : this.innerProperties().sku();
    }

    public PremierAddOnPatchResource withSku(String sku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PremierAddOnPatchResourceProperties();
        }
        this.innerProperties().withSku(sku);
        return this;
    }

    public String product() {
        return this.innerProperties() == null ? null : this.innerProperties().product();
    }

    public PremierAddOnPatchResource withProduct(String product) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PremierAddOnPatchResourceProperties();
        }
        this.innerProperties().withProduct(product);
        return this;
    }

    public String vendor() {
        return this.innerProperties() == null ? null : this.innerProperties().vendor();
    }

    public PremierAddOnPatchResource withVendor(String vendor) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PremierAddOnPatchResourceProperties();
        }
        this.innerProperties().withVendor(vendor);
        return this;
    }

    public String marketplacePublisher() {
        return this.innerProperties() == null ? null : this.innerProperties().marketplacePublisher();
    }

    public PremierAddOnPatchResource withMarketplacePublisher(String marketplacePublisher) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PremierAddOnPatchResourceProperties();
        }
        this.innerProperties().withMarketplacePublisher(marketplacePublisher);
        return this;
    }

    public String marketplaceOffer() {
        return this.innerProperties() == null ? null : this.innerProperties().marketplaceOffer();
    }

    public PremierAddOnPatchResource withMarketplaceOffer(String marketplaceOffer) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PremierAddOnPatchResourceProperties();
        }
        this.innerProperties().withMarketplaceOffer(marketplaceOffer);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static PremierAddOnPatchResource fromJson(JsonReader jsonReader) throws IOException {
        return (PremierAddOnPatchResource)((Object)jsonReader.readObject(reader -> {
            PremierAddOnPatchResource deserializedPremierAddOnPatchResource = new PremierAddOnPatchResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPremierAddOnPatchResource.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPremierAddOnPatchResource.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPremierAddOnPatchResource.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedPremierAddOnPatchResource.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPremierAddOnPatchResource.innerProperties = PremierAddOnPatchResourceProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPremierAddOnPatchResource;
        }));
    }
}

