/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.Request;
import com.azure.resourcemanager.appservice.models.Response;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class RequestHistoryProperties
implements JsonSerializable<RequestHistoryProperties> {
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private Request request;
    private Response response;

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public RequestHistoryProperties withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public RequestHistoryProperties withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public Request request() {
        return this.request;
    }

    public RequestHistoryProperties withRequest(Request request) {
        this.request = request;
        return this;
    }

    public Response response() {
        return this.response;
    }

    public RequestHistoryProperties withResponse(Response response) {
        this.response = response;
        return this;
    }

    public void validate() {
        if (this.request() != null) {
            this.request().validate();
        }
        if (this.response() != null) {
            this.response().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeJsonField("request", (JsonSerializable)this.request);
        jsonWriter.writeJsonField("response", (JsonSerializable)this.response);
        return jsonWriter.writeEndObject();
    }

    public static RequestHistoryProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RequestHistoryProperties)jsonReader.readObject(reader -> {
            RequestHistoryProperties deserializedRequestHistoryProperties = new RequestHistoryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    deserializedRequestHistoryProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedRequestHistoryProperties.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("request".equals(fieldName)) {
                    deserializedRequestHistoryProperties.request = Request.fromJson(reader);
                    continue;
                }
                if ("response".equals(fieldName)) {
                    deserializedRequestHistoryProperties.response = Response.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRequestHistoryProperties;
        });
    }
}

