/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.resourcemanager.implementation.provisioning;

import com.azure.resourcemanager.AzureResourceManager;
import com.azure.spring.cloud.core.properties.resource.AzureResourceMetadata;
import com.azure.spring.cloud.resourcemanager.implementation.crud.ServiceBusQueueCrud;
import com.azure.spring.cloud.resourcemanager.implementation.crud.ServiceBusTopicCrud;
import com.azure.spring.cloud.resourcemanager.implementation.crud.ServiceBusTopicSubscriptionCrud;
import com.azure.spring.cloud.resourcemanager.implementation.provisioning.ServiceBusProvisioner;
import reactor.util.function.Tuples;

public class DefaultServiceBusProvisioner
implements ServiceBusProvisioner {
    private final ServiceBusQueueCrud queueCrud;
    private final ServiceBusTopicCrud topicCrud;
    private final ServiceBusTopicSubscriptionCrud subscriptionCrud;

    public DefaultServiceBusProvisioner(AzureResourceManager azureResourceManager, AzureResourceMetadata azureResourceMetadata) {
        this.queueCrud = new ServiceBusQueueCrud(azureResourceManager, azureResourceMetadata);
        this.topicCrud = new ServiceBusTopicCrud(azureResourceManager, azureResourceMetadata);
        this.subscriptionCrud = new ServiceBusTopicSubscriptionCrud(azureResourceManager, azureResourceMetadata);
    }

    @Override
    public void provisionQueue(String namespace, String queue) {
        this.queueCrud.getOrCreate(Tuples.of((Object)namespace, (Object)queue));
    }

    @Override
    public void provisionTopic(String namespace, String topic) {
        this.topicCrud.getOrCreate(Tuples.of((Object)namespace, (Object)topic));
    }

    @Override
    public void provisionSubscription(String namespace, String topic, String subscription) {
        this.subscriptionCrud.getOrCreate(Tuples.of((Object)namespace, (Object)topic, (Object)subscription));
    }
}

