/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.cap;

import com.basho.riak.client.cap.Quora;

public final class Quorum {
    private final int i;
    private final Quora quorum;

    public Quorum(int i) {
        switch (i) {
            case -2: {
                this.quorum = Quora.ONE;
                break;
            }
            case -3: {
                this.quorum = Quora.QUORUM;
                break;
            }
            case -4: {
                this.quorum = Quora.ALL;
                break;
            }
            case -5: {
                this.quorum = Quora.DEFAULT;
                break;
            }
            default: {
                this.quorum = Quora.INTEGER;
            }
        }
        this.i = i;
    }

    public Quorum(Quora quorum) {
        this.quorum = quorum;
        this.i = quorum.getValue();
    }

    public boolean isSymbolic() {
        return !Quora.INTEGER.equals((Object)this.quorum);
    }

    public int getIntValue() {
        return this.i;
    }

    public Quora getSymbolicValue() {
        return this.quorum;
    }

    public String getName() {
        return this.quorum.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.i;
        result = 31 * result + (this.quorum == null ? 0 : this.quorum.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Quorum)) {
            return false;
        }
        Quorum other = (Quorum)obj;
        if (this.i != other.i) {
            return false;
        }
        return this.quorum == other.quorum;
    }
}

