/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.http.request;

import com.basho.riak.client.http.RiakConfig;
import com.basho.riak.client.http.util.ClientUtils;

public class IndexRequest {
    private final String bucketName;
    private final String indexName;
    private final String indexKey;
    private final String rangeStart;
    private final String rangeEnd;
    private final boolean returnTerms;
    private final Integer maxResults;
    private String continuation;

    private IndexRequest(Builder builder) {
        this.bucketName = builder.bucketName;
        this.indexName = builder.indexName;
        this.indexKey = builder.indexKey;
        this.rangeStart = builder.rangeStart;
        this.rangeEnd = builder.rangeEnd;
        this.returnTerms = builder.returnTerms;
        this.maxResults = builder.maxResults;
        this.continuation = builder.continuation;
    }

    public void setContinuation(String continuation) {
        this.continuation = continuation;
    }

    public String makeURIString(RiakConfig config) {
        StringBuilder sb = new StringBuilder(config.getBaseUrl()).append("/buckets/").append(ClientUtils.urlEncode(this.bucketName)).append("/index/").append(this.indexName).append("/");
        if (this.indexKey != null) {
            sb.append(this.indexKey);
        } else {
            sb.append(this.rangeStart).append("/").append(this.rangeEnd);
        }
        return sb.toString();
    }

    public boolean isReturnTerms() {
        return this.returnTerms;
    }

    public boolean hasMaxResults() {
        return this.maxResults != null;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public boolean hasContinuation() {
        return this.continuation != null;
    }

    public String getContinuation() {
        return this.continuation;
    }

    public String getIndexKey() {
        return this.indexKey;
    }

    public static class Builder {
        private final String bucketName;
        private final String indexName;
        private String indexKey;
        private String rangeStart;
        private String rangeEnd;
        private boolean returnTerms;
        private Integer maxResults;
        private String continuation;

        public Builder(String bucketName, String indexName) {
            if (bucketName == null || bucketName.equalsIgnoreCase("") || indexName == null || indexName.equalsIgnoreCase("")) {
                throw new IllegalArgumentException("Bucket or Index can not be null or empty");
            }
            this.bucketName = bucketName;
            this.indexName = indexName;
        }

        public Builder withIndexKey(String key) {
            this.indexKey = key;
            return this;
        }

        public Builder withIndexKey(long key) {
            this.indexKey = String.valueOf(key);
            return this;
        }

        public Builder withRangeStart(String startingIndex) {
            this.rangeStart = startingIndex;
            return this;
        }

        public Builder withRangeStart(long startIndex) {
            this.rangeStart = String.valueOf(startIndex);
            return this;
        }

        public Builder withRangeEnd(String endIndex) {
            this.rangeEnd = endIndex;
            return this;
        }

        public Builder withRangeEnd(long endIndex) {
            this.rangeEnd = String.valueOf(endIndex);
            return this;
        }

        public Builder withReturnKeyAndIndex(boolean returnBoth) {
            this.returnTerms = returnBoth;
            return this;
        }

        public Builder withMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public Builder withContinuation(String continuation) {
            this.continuation = continuation;
            return this;
        }

        public IndexRequest build() {
            if (this.rangeStart == null && this.rangeEnd == null && this.indexKey == null) {
                throw new IllegalArgumentException("An index key or range must be supplied");
            }
            if (this.rangeStart != null && this.rangeEnd == null || this.rangeEnd != null && this.rangeStart == null) {
                throw new IllegalArgumentException("When specifying ranges both start and end must be set");
            }
            return new IndexRequest(this);
        }
    }
}

