/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.http.response;

import com.basho.riak.client.http.request.IndexRequest;
import com.basho.riak.client.http.response.HttpResponse;
import com.basho.riak.client.http.response.IndexEntry;
import com.basho.riak.client.http.util.Multipart;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexResponseV2 {
    private final List<IndexEntry> entries;
    private String continuation;
    private final IndexRequest request;

    public IndexResponseV2(IndexRequest request, HttpResponse r) throws JSONException {
        this.request = request;
        this.entries = new ArrayList<IndexEntry>();
        if (r != null && r.isSuccess()) {
            byte[] entireResponse = r.getBody();
            List<Multipart.Part> parts = Multipart.parse(r.getHttpHeaders(), entireResponse);
            for (Multipart.Part part : parts) {
                int i;
                JSONArray jArray;
                JSONObject obj = new JSONObject(part.getBodyAsString());
                if (obj.has("keys")) {
                    jArray = obj.getJSONArray("keys");
                    for (i = 0; i < jArray.length(); ++i) {
                        if (request.isReturnTerms()) {
                            this.entries.add(new IndexEntry(request.getIndexKey(), jArray.getString(i)));
                            continue;
                        }
                        this.entries.add(new IndexEntry(jArray.getString(i)));
                    }
                    continue;
                }
                if (obj.has("results")) {
                    jArray = obj.getJSONArray("results");
                    for (i = 0; i < jArray.length(); ++i) {
                        JSONObject rObj = jArray.getJSONObject(i);
                        String indexValue = rObj.keys().next().toString();
                        this.entries.add(new IndexEntry(indexValue, rObj.getString(indexValue)));
                    }
                    continue;
                }
                if (!obj.has("continuation")) continue;
                this.continuation = obj.getString("continuation");
            }
        }
    }

    public List<IndexEntry> getEntries() {
        return this.entries;
    }

    public boolean hasContinuation() {
        return this.continuation != null;
    }

    public String getContinuation() {
        return this.continuation;
    }
}

