/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.http.util;

import com.basho.riak.client.http.BinIndex;
import com.basho.riak.client.http.IntIndex;
import com.basho.riak.client.http.RiakClient;
import com.basho.riak.client.http.RiakConfig;
import com.basho.riak.client.http.RiakIndex;
import com.basho.riak.client.http.RiakLink;
import com.basho.riak.client.http.RiakObject;
import com.basho.riak.client.http.response.RiakIORuntimeException;
import com.basho.riak.client.http.util.CheckedThrower;
import com.basho.riak.client.http.util.LinkHeader;
import com.basho.riak.client.http.util.Multipart;
import com.basho.riak.client.util.CharsetUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.cookie.DateParseException;
import org.apache.http.impl.cookie.DateUtils;
import org.apache.http.params.HttpParams;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientUtils {
    private static final String COMMA = ",";
    private static final String[] DATE_FORMATS = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy"};
    private static String URL_PATH_MASK = "^(?:[A-Za-z0-9+-\\.]+://)?[^/]*";
    private static Random rng = new Random();

    public static HttpClient newHttpClient(RiakConfig config) {
        HttpClient http = config.getHttpClient();
        if (http == null) {
            PoolingClientConnectionManager m = new PoolingClientConnectionManager();
            if (config.getMaxConnections() != null) {
                m.setMaxTotal(config.getMaxConnections().intValue());
                m.setDefaultMaxPerRoute(config.getMaxConnections().intValue());
            }
            http = new DefaultHttpClient((ClientConnectionManager)m);
            if (config.getRetryHandler() != null) {
                ((DefaultHttpClient)http).setHttpRequestRetryHandler(config.getRetryHandler());
            }
        }
        HttpParams cp = http.getParams();
        if (config.getTimeout() != null) {
            cp.setIntParameter("http.connection.timeout", config.getTimeout().intValue());
            cp.setIntParameter("http.socket.timeout", config.getTimeout().intValue());
        }
        return http;
    }

    public static String makeURI(RiakConfig config, String bucket) {
        return config.getUrl() + "/" + ClientUtils.urlEncode(bucket);
    }

    public static String makeURI(RiakConfig config, String bucket, String key) {
        if (key == null) {
            return ClientUtils.makeURI(config, bucket);
        }
        return ClientUtils.makeURI(config, bucket) + "/" + ClientUtils.urlEncode(key);
    }

    public static String makeURI(RiakConfig config, String bucket, String key, String extra) {
        if (extra == null) {
            return ClientUtils.makeURI(config, bucket, key);
        }
        if (!extra.startsWith("?") && !extra.startsWith("/")) {
            extra = "/" + extra;
        }
        return ClientUtils.makeURI(config, bucket, key) + extra;
    }

    public static String makeURI(RiakConfig config, String bucket, String index, String[] values) {
        StringBuilder url = ClientUtils.makeBaseIndexURI(config, bucket, index).append(values[0]);
        if (values.length > 1) {
            url.append("/").append(values[1]);
        }
        return url.toString();
    }

    public static String makeURI(RiakConfig config, String bucket, String index, long[] values) {
        StringBuilder url = ClientUtils.makeBaseIndexURI(config, bucket, index).append(values[0]);
        if (values.length > 1) {
            url.append("/").append(values[1]);
        }
        return url.toString();
    }

    private static StringBuilder makeBaseIndexURI(RiakConfig config, String bucket, String index) {
        return new StringBuilder(config.getBaseUrl()).append("/").append("buckets").append("/").append(ClientUtils.urlEncode(bucket)).append("/").append("index").append("/").append(index).append("/");
    }

    public static String getPathFromUrl(String url) {
        if (url == null) {
            return null;
        }
        return url.replaceFirst(URL_PATH_MASK, "");
    }

    public static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException unreached) {
            throw new IllegalStateException("UTF-8 must be supported", unreached);
        }
    }

    public static String urlDecode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException unreached) {
            throw new IllegalStateException("UTF-8 must be supported", unreached);
        }
    }

    public static String encodeClientId(byte[] clientId) {
        if (clientId == null || clientId.length < 4) {
            throw new IllegalArgumentException("ClientId must be at least 4 bytes");
        }
        try {
            return new String(Base64.encodeBase64((byte[])new byte[]{clientId[0], clientId[1], clientId[2], clientId[3]}), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 support is required by JVM");
        }
    }

    public static String encodeClientId(String clientId) {
        return ClientUtils.encodeClientId(CharsetUtils.asBytes(clientId, CharsetUtils.ISO_8859_1));
    }

    public static String randomClientId() {
        byte[] rnd = new byte[4];
        rng.nextBytes(rnd);
        return ClientUtils.encodeClientId(rnd);
    }

    public static String unquoteString(String s) {
        if (s.startsWith("\"") && s.endsWith("\"")) {
            s = s.substring(1, s.length() - 1);
        }
        return s.replaceAll("\\\\(.)", "$1");
    }

    public static Map<String, String> asHeaderMap(Header[] headers) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (headers != null) {
            for (Header header : headers) {
                m.put(header.getName().toLowerCase(), header.getValue());
            }
        }
        return m;
    }

    public static Map<String, String> jsonObjectAsMap(JSONObject json) {
        if (json == null) {
            return null;
        }
        HashMap<String, String> m = new HashMap<String, String>();
        Iterator iter = json.keys();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj == null) continue;
            String key = obj.toString();
            m.put(key, json.optString(key));
        }
        return m;
    }

    public static List<String> jsonArrayAsList(JSONArray json) {
        if (json == null) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < json.length(); ++i) {
            l.add(json.optString(i));
        }
        return l;
    }

    public static String join(String[] arr, String delimiter) {
        StringBuffer buf = new StringBuffer();
        if (arr == null || arr.length == 0) {
            return null;
        }
        buf.append(arr[0]);
        for (int i = 1; i < arr.length; ++i) {
            buf.append(delimiter);
            buf.append(arr[i]);
        }
        return buf.toString();
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int readCount;
        byte[] buffer = new byte[1024];
        while ((readCount = in.read(buffer)) != -1) {
            out.write(buffer, 0, readCount);
        }
    }

    public static List<RiakLink> parseLinkHeader(String header) {
        ArrayList<RiakLink> links = new ArrayList<RiakLink>();
        Map<String, List<Map<String, String>>> parsedLinks = LinkHeader.parse(header);
        for (Map.Entry<String, List<Map<String, String>>> e : parsedLinks.entrySet()) {
            String url = e.getKey();
            for (Map<String, String> params : e.getValue()) {
                RiakLink link = ClientUtils.parseOneLink(url, params);
                if (link == null) continue;
                links.add(link);
            }
        }
        return links;
    }

    private static RiakLink parseOneLink(String url, Map<String, String> params) {
        String[] parts;
        String tag = params.get("riaktag");
        if (tag != null && (parts = url.split("/")).length >= 2) {
            return new RiakLink(parts[parts.length - 2], parts[parts.length - 1], tag);
        }
        return null;
    }

    public static List<RiakIndex> parseIndexHeaders(Map<String, String> headers) {
        ArrayList<RiakIndex> indexes = new ArrayList<RiakIndex>();
        if (headers != null) {
            for (Map.Entry<String, String> e : headers.entrySet()) {
                String header = e.getKey();
                if (header == null || !header.toLowerCase().startsWith("x-riak-index-")) continue;
                String name = header.substring("x-riak-index-".length());
                String value = e.getValue();
                StringTokenizer st = new StringTokenizer(value, COMMA);
                if (name.endsWith("_bin")) {
                    while (st.hasMoreTokens()) {
                        indexes.add(new BinIndex(name, st.nextToken().trim()));
                    }
                    continue;
                }
                if (!name.endsWith("_int")) continue;
                while (st.hasMoreElements()) {
                    indexes.add(new IntIndex(name, Long.parseLong(st.nextToken().trim())));
                }
            }
        }
        return indexes;
    }

    public static Map<String, String> parseUsermeta(Map<String, String> headers) {
        HashMap<String, String> usermeta = new HashMap<String, String>();
        if (headers != null) {
            for (Map.Entry<String, String> e : headers.entrySet()) {
                String header = e.getKey();
                if (header == null || !header.toLowerCase().startsWith("x-riak-meta-")) continue;
                usermeta.put(header.substring("x-riak-meta-".length()), e.getValue());
            }
        }
        return usermeta;
    }

    public static List<RiakObject> parseMultipart(RiakClient riak, String bucket, String key, Map<String, String> docHeaders, byte[] docBody) {
        String vclock = null;
        boolean siblingVclock = false;
        if (docHeaders != null && (vclock = docHeaders.get("x-riak-vclock")) != null) {
            siblingVclock = true;
        }
        List<Multipart.Part> parts = Multipart.parse(docHeaders, docBody);
        ArrayList<RiakObject> objects = new ArrayList<RiakObject>();
        if (parts != null) {
            for (Multipart.Part part : parts) {
                String[] locationParts;
                Map<String, String> headers = part.getHeaders();
                if (!siblingVclock) {
                    vclock = headers.get("x-riak-vclock");
                }
                if (vclock == null) {
                    throw new IllegalStateException("no vclock found");
                }
                List<RiakLink> links = ClientUtils.parseLinkHeader(headers.get("link"));
                List<RiakIndex> indexes = ClientUtils.parseIndexHeaders(headers);
                Map<String, String> usermeta = ClientUtils.parseUsermeta(headers);
                String location = headers.get("location");
                String partBucket = bucket;
                String partKey = key;
                if (location != null && (locationParts = location.split("/")).length >= 2) {
                    partBucket = locationParts[locationParts.length - 2];
                    partKey = ClientUtils.urlDecode(locationParts[locationParts.length - 1]);
                }
                RiakObject o = new RiakObject(riak, partBucket, partKey, part.getBody(), headers.get("content-type"), links, usermeta, vclock, headers.get("last-modified"), headers.get("etag"), indexes, headers.get("x-riak-deleted") != null);
                objects.add(o);
            }
        }
        return objects;
    }

    public static void throwChecked(Throwable exception) {
        new CheckedThrower().throwChecked(exception);
    }

    public static byte[] bufferStream(InputStream valueStream) {
        if (valueStream == null) {
            return new byte[0];
        }
        try {
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            byte[] data = new byte[4096];
            int l = 0;
            while ((l = valueStream.read(data)) >= 0) {
                tmp.write(data, 0, l);
            }
            return tmp.toByteArray();
        }
        catch (IOException e) {
            throw new RiakIORuntimeException(e);
        }
    }

    public static Date parseDate(String date) {
        try {
            return DateUtils.parseDate((String)date, (String[])DATE_FORMATS);
        }
        catch (DateParseException e) {
            return null;
        }
    }
}

