/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.raw.http;

import com.basho.riak.client.http.response.ListBucketsResponse;
import com.basho.riak.client.query.RiakStreamingRuntimeException;
import com.basho.riak.client.query.StreamingOperation;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BucketSource
implements StreamingOperation<String> {
    private static final Timer timer = new Timer("riak-client-key-stream-timeout-thread", true);
    private final ListBucketsResponse listBucketsResponse;
    private final Iterator<String> buckets;
    private ReaperTask reaper;

    public BucketSource(ListBucketsResponse listBucketsResponse) {
        this.listBucketsResponse = listBucketsResponse;
        this.buckets = listBucketsResponse.getBuckets().iterator();
        this.reaper = new ReaperTask(this, listBucketsResponse);
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = false;
        try {
            hasNext = this.buckets.hasNext();
        }
        catch (RuntimeException re) {
            throw new RiakStreamingRuntimeException(re);
        }
        finally {
            if (!hasNext) {
                this.cancel();
            }
        }
        return hasNext;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.buckets.next();
    }

    @Override
    public void cancel() {
        this.reaper.cancel();
        this.listBucketsResponse.close();
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public List<String> getAll() {
        ArrayList<String> list = new ArrayList<String>();
        while (this.hasNext()) {
            list.add(this.next());
        }
        return list;
    }

    @Override
    public boolean hasContinuation() {
        return false;
    }

    @Override
    public String getContinuation() {
        return null;
    }

    static class ReaperTask
    extends TimerTask {
        private final ListBucketsResponse bucketResponse;
        private WeakReference<?> ref;

        ReaperTask(Object holder, ListBucketsResponse conn) {
            this.bucketResponse = conn;
            this.ref = new WeakReference<Object>(holder);
            timer.scheduleAtFixedRate((TimerTask)this, 500L, 500L);
        }

        public synchronized void run() {
            if (this.ref != null && this.ref.get() == null) {
                this.cancel();
                this.bucketResponse.close();
            }
        }

        public synchronized boolean cancel() {
            this.ref = null;
            return super.cancel();
        }
    }
}

