/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.raw.pbc;

import com.basho.riak.client.convert.ConversionException;
import com.basho.riak.client.query.MapReduceResult;
import com.basho.riak.pbc.MapReduceResponseSource;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.json.JSONArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBMapReduceResult
implements MapReduceResult {
    private final FutureTask<String> rawResultTask;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public static PBMapReduceResult newResult(MapReduceResponseSource response) {
        PBMapReduceResult result = new PBMapReduceResult(response);
        result.init();
        return result;
    }

    private void init() {
        this.rawResultTask.run();
    }

    private PBMapReduceResult(final MapReduceResponseSource response) {
        this.rawResultTask = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                JSONArray results = MapReduceResponseSource.readAllResults(response);
                return results.toString();
            }
        });
    }

    @Override
    public String getResultRaw() {
        try {
            return this.rawResultTask.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public <T> Collection<T> getResult(Class<T> resultType) throws ConversionException {
        try {
            return (Collection)this.objectMapper.readValue(this.getResultRaw(), (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(Collection.class, resultType));
        }
        catch (IOException e) {
            throw new ConversionException(e);
        }
    }
}

