/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.raw.pbc;

import com.basho.riak.client.query.RiakStreamingRuntimeException;
import com.basho.riak.client.query.StreamingOperation;
import com.basho.riak.pbc.RiakStreamClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PBStreamingOperation<S, T>
implements StreamingOperation<T> {
    protected final RiakStreamClient<S> client;

    public PBStreamingOperation(RiakStreamClient<S> client) {
        this.client = client;
    }

    @Override
    public List<T> getAll() {
        ArrayList<T> list = new ArrayList<T>();
        while (this.hasNext()) {
            list.add(this.next());
        }
        return list;
    }

    @Override
    public void cancel() {
        this.client.close();
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public abstract T next();

    @Override
    public boolean hasNext() {
        boolean hasNext = false;
        try {
            hasNext = this.client.hasNext();
        }
        catch (IOException ex) {
            throw new RiakStreamingRuntimeException(ex);
        }
        return hasNext;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public boolean hasContinuation() {
        return this.client.hasContinuation();
    }

    @Override
    public String getContinuation() {
        return this.client.getContinuation() == null ? null : this.client.getContinuation().toStringUtf8();
    }
}

