/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.pbc;

import com.basho.riak.pbc.CommitHook;
import com.basho.riak.pbc.ModuleFunction;
import java.util.ArrayList;
import java.util.List;
import shaded.com.bash.riak.protobuf.RiakPB;
import shaded.com.google.protobuf.ByteString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BucketProperties {
    private Boolean allowMult;
    private Integer nValue;
    private Boolean lastWriteWins;
    private List<CommitHook> precommitHooks = new ArrayList<CommitHook>();
    private List<CommitHook> postcommitHooks = new ArrayList<CommitHook>();
    private ModuleFunction cHashFun;
    private ModuleFunction linkFun;
    private Long oldVClock;
    private Long youngVClock;
    private Integer bigVClock;
    private Integer smallVClock;
    private Integer pr;
    private Integer r;
    private Integer w;
    private Integer pw;
    private Integer dw;
    private Integer rw;
    private Boolean basicQuorum;
    private Boolean notFoundOk;
    private Boolean searchEnabled;
    private String backend;

    public void init(RiakPB.RpbGetBucketResp resp) {
        if (resp.hasProps()) {
            RiakPB.RpbBucketProps props = resp.getProps();
            if (props.hasAllowMult()) {
                this.allowMult = props.getAllowMult();
            }
            if (props.hasNVal()) {
                this.nValue = new Integer(props.getNVal());
            }
            if (props.hasLastWriteWins()) {
                this.lastWriteWins = props.getLastWriteWins();
            }
            if (props.hasHasPrecommit()) {
                this.precommitHooks = this.parseHooks(props.getPrecommitList());
            }
            if (props.hasHasPostcommit()) {
                this.postcommitHooks = this.parseHooks(props.getPostcommitList());
            }
            if (props.hasChashKeyfun()) {
                this.cHashFun = new ModuleFunction(props.getChashKeyfun().getModule().toStringUtf8(), props.getChashKeyfun().getFunction().toStringUtf8());
            }
            if (props.hasLinkfun()) {
                this.linkFun = new ModuleFunction(props.getLinkfun().getModule().toStringUtf8(), props.getLinkfun().getFunction().toStringUtf8());
            }
            if (props.hasPr()) {
                this.pr = props.getPr();
            }
            if (props.hasR()) {
                this.r = props.getR();
            }
            if (props.hasW()) {
                this.w = props.getW();
            }
            if (props.hasPw()) {
                this.pw = props.getPw();
            }
            if (props.hasDw()) {
                this.dw = props.getDw();
            }
            if (props.hasRw()) {
                this.rw = props.getRw();
            }
            if (props.hasBasicQuorum()) {
                this.basicQuorum = props.getBasicQuorum();
            }
            if (props.hasNotfoundOk()) {
                this.notFoundOk = props.getNotfoundOk();
            }
            if (props.hasSearch()) {
                this.searchEnabled = props.getSearch();
            }
            if (props.hasBackend()) {
                this.backend = props.getBackend().toStringUtf8();
            }
            if (props.hasYoungVclock()) {
                this.youngVClock = this.getUnsignedIntValue(props.getYoungVclock());
            }
            if (props.hasOldVclock()) {
                this.oldVClock = this.getUnsignedIntValue(props.getOldVclock());
            }
            if (props.hasBigVclock()) {
                this.bigVClock = props.getBigVclock();
            }
            if (props.hasSmallVclock()) {
                this.smallVClock = props.getSmallVclock();
            }
        }
    }

    private long getUnsignedIntValue(int i) {
        return (long)i & 0xFFFFFFFFL;
    }

    private List<CommitHook> parseHooks(List<RiakPB.RpbCommitHook> hooks) {
        ArrayList<CommitHook> list = new ArrayList<CommitHook>(hooks.size());
        for (RiakPB.RpbCommitHook hook : hooks) {
            CommitHook ph;
            if (hook.hasName()) {
                ph = new CommitHook(hook.getName().toStringUtf8());
                list.add(ph);
                continue;
            }
            ph = new CommitHook(hook.getModfun().getModule().toStringUtf8(), hook.getModfun().getFunction().toStringUtf8());
            list.add(ph);
        }
        return list;
    }

    private List<RiakPB.RpbCommitHook> convertHooks(List<CommitHook> hookList) {
        ArrayList<RiakPB.RpbCommitHook> pbHookList = new ArrayList<RiakPB.RpbCommitHook>(hookList.size());
        RiakPB.RpbCommitHook.Builder builder = RiakPB.RpbCommitHook.newBuilder();
        RiakPB.RpbModFun.Builder mfBuilder = RiakPB.RpbModFun.newBuilder();
        for (CommitHook hook : hookList) {
            if (hook.isJavascript()) {
                builder.setName(ByteString.copyFromUtf8(hook.getJsName()));
            } else {
                mfBuilder.setModule(ByteString.copyFromUtf8(hook.getErlModule()));
                mfBuilder.setFunction(ByteString.copyFromUtf8(hook.getErlFunction()));
                builder.setModfun(mfBuilder);
            }
            pbHookList.add(builder.build());
            builder.clear();
            mfBuilder.clear();
        }
        return pbHookList;
    }

    private RiakPB.RpbModFun convertModFun(ModuleFunction mf) {
        return RiakPB.RpbModFun.newBuilder().setModule(ByteString.copyFromUtf8(mf.getModule())).setFunction(ByteString.copyFromUtf8(mf.getFunction())).build();
    }

    public Boolean getAllowMult() {
        return this.allowMult;
    }

    public Integer getNValue() {
        return this.nValue;
    }

    public BucketProperties allowMult(boolean val) {
        this.allowMult = val;
        return this;
    }

    public BucketProperties nValue(int val) {
        this.nValue = val;
        return this;
    }

    RiakPB.RpbBucketProps build() {
        RiakPB.RpbBucketProps.Builder builder = RiakPB.RpbBucketProps.newBuilder();
        if (this.allowMult != null) {
            builder.setAllowMult(this.allowMult);
        }
        if (this.nValue != null) {
            builder.setNVal(this.nValue);
        }
        if (this.lastWriteWins != null) {
            builder.setLastWriteWins(this.lastWriteWins);
        }
        if (this.backend != null) {
            builder.setBackend(ByteString.copyFromUtf8(this.backend));
        }
        if (this.smallVClock != null) {
            builder.setSmallVclock(this.smallVClock);
        }
        if (this.bigVClock != null) {
            builder.setBigVclock(this.bigVClock);
        }
        if (this.youngVClock != null) {
            builder.setYoungVclock(this.youngVClock.intValue());
        }
        if (this.oldVClock != null) {
            builder.setOldVclock(this.oldVClock.intValue());
        }
        if (this.r != null) {
            builder.setR(this.r);
        }
        if (this.w != null) {
            builder.setW(this.w);
        }
        if (this.rw != null) {
            builder.setRw(this.rw);
        }
        if (this.dw != null) {
            builder.setDw(this.dw);
        }
        if (this.pr != null) {
            builder.setPr(this.pr);
        }
        if (this.pw != null) {
            builder.setPw(this.pw);
        }
        if (this.basicQuorum != null) {
            builder.setBasicQuorum(this.basicQuorum);
        }
        if (this.notFoundOk != null) {
            builder.setNotfoundOk(this.notFoundOk);
        }
        if (this.searchEnabled != null) {
            builder.setSearch(this.searchEnabled);
        }
        if (this.precommitHooks.size() > 0) {
            builder.addAllPrecommit(this.convertHooks(this.precommitHooks));
        }
        if (this.postcommitHooks.size() > 0) {
            builder.addAllPostcommit(this.convertHooks(this.postcommitHooks));
        }
        if (this.cHashFun != null) {
            builder.setChashKeyfun(this.convertModFun(this.cHashFun));
        }
        if (this.linkFun != null) {
            builder.setLinkfun(this.convertModFun(this.linkFun));
        }
        return builder.build();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allowMult == null ? 0 : this.allowMult.hashCode());
        result = 31 * result + (this.nValue == null ? 0 : this.nValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketProperties)) {
            return false;
        }
        BucketProperties other = (BucketProperties)obj;
        if (this.allowMult == null ? other.allowMult != null : !this.allowMult.equals(other.allowMult)) {
            return false;
        }
        return !(this.nValue == null ? other.nValue != null : !this.nValue.equals(other.nValue));
    }

    public String toString() {
        return String.format("BucketProperties [allowMult=%s, nValue=%s]", this.allowMult, this.nValue);
    }

    public Boolean getLastWriteWins() {
        return this.lastWriteWins;
    }

    public BucketProperties lastWriteWins(Boolean lastWriteWins) {
        this.lastWriteWins = lastWriteWins;
        return this;
    }

    public List<CommitHook> getPrecommitHooks() {
        return this.precommitHooks;
    }

    public BucketProperties precommitHooks(List<CommitHook> precommitHooks) {
        this.precommitHooks = precommitHooks;
        return this;
    }

    public List<CommitHook> getPostcommitHooks() {
        return this.postcommitHooks;
    }

    public BucketProperties postcommitHooks(List<CommitHook> postcommitHooks) {
        this.postcommitHooks = postcommitHooks;
        return this;
    }

    public ModuleFunction getcHashFun() {
        return this.cHashFun;
    }

    public BucketProperties cHashFun(ModuleFunction cHashFun) {
        this.cHashFun = cHashFun;
        return this;
    }

    public ModuleFunction getLinkFun() {
        return this.linkFun;
    }

    public BucketProperties linkFun(ModuleFunction linkFun) {
        this.linkFun = linkFun;
        return this;
    }

    public Integer getPr() {
        return this.pr;
    }

    public BucketProperties pr(Integer pr) {
        this.pr = pr;
        return this;
    }

    public Integer getR() {
        return this.r;
    }

    public BucketProperties r(Integer r) {
        this.r = r;
        return this;
    }

    public Integer getW() {
        return this.w;
    }

    public BucketProperties w(Integer w) {
        this.w = w;
        return this;
    }

    public Integer getPw() {
        return this.pw;
    }

    public BucketProperties pw(Integer pw) {
        this.pw = pw;
        return this;
    }

    public Integer getDw() {
        return this.dw;
    }

    public BucketProperties dw(Integer dw) {
        this.dw = dw;
        return this;
    }

    public Integer getRw() {
        return this.rw;
    }

    public BucketProperties rw(Integer rw) {
        this.rw = rw;
        return this;
    }

    public Boolean getBasicQuorum() {
        return this.basicQuorum;
    }

    public BucketProperties basicQuorum(Boolean basicQuorum) {
        this.basicQuorum = basicQuorum;
        return this;
    }

    public Boolean getNotFoundOk() {
        return this.notFoundOk;
    }

    public BucketProperties notFoundOk(Boolean notFoundOk) {
        this.notFoundOk = notFoundOk;
        return this;
    }

    public Boolean getSearchEnabled() {
        return this.searchEnabled;
    }

    public BucketProperties searchEnabled(Boolean searchEnabled) {
        this.searchEnabled = searchEnabled;
        return this;
    }

    public String getBackend() {
        return this.backend;
    }

    public BucketProperties backend(String backend) {
        this.backend = backend;
        return this;
    }

    public Long getYoungVClock() {
        return this.youngVClock;
    }

    public BucketProperties youngVClock(Long youngVClock) {
        this.youngVClock = youngVClock;
        return this;
    }

    public Long getOldVClock() {
        return this.oldVClock;
    }

    public BucketProperties oldVclock(Long oldVClock) {
        this.oldVClock = oldVClock;
        return this;
    }

    public Integer getSmallVClock() {
        return this.smallVClock;
    }

    public BucketProperties smallVClock(Integer smallVClock) {
        this.smallVClock = smallVClock;
        return this;
    }

    public Integer getBigVClock() {
        return this.bigVClock;
    }

    public BucketProperties bigVClock(Integer bigVClock) {
        this.bigVClock = bigVClock;
        return this;
    }
}

