/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.pbc;

import com.basho.riak.pbc.RiakClient;
import com.basho.riak.pbc.RiakConnection;
import com.basho.riak.pbc.RiakStreamClient;
import java.io.IOException;
import java.util.NoSuchElementException;
import shaded.com.bash.riak.protobuf.RiakKvPB;
import shaded.com.google.protobuf.ByteString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BucketSource
extends RiakStreamClient<ByteString> {
    private RiakKvPB.RpbListBucketsResp r;
    private int i;

    public BucketSource(RiakClient client, RiakConnection conn) throws IOException {
        super(client, conn);
        this.get_next_response();
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.isClosed()) {
            return false;
        }
        if (this.r_is_exhausted()) {
            this.get_next_response();
        }
        return !this.isClosed();
    }

    @Override
    public ByteString next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.r.getBuckets(this.i++);
    }

    private boolean r_is_exhausted() {
        return this.i == this.r.getBucketsCount();
    }

    private void get_next_response() throws IOException {
        if (this.isClosed()) {
            return;
        }
        assert (this.r == null || this.r_is_exhausted());
        do {
            if (this.r != null && this.r.hasDone() && this.r.getDone()) {
                this.close();
                return;
            }
            try {
                byte[] data = this.conn.receive(16);
                if (data == null) {
                    this.close();
                    throw new IOException("received empty response");
                }
                this.r = RiakKvPB.RpbListBucketsResp.parseFrom(data);
                this.i = 0;
            }
            catch (IOException e) {
                this.close();
                throw e;
            }
        } while (this.r.getBucketsCount() == 0);
    }
}

