/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.pbc;

import java.util.ArrayList;
import java.util.List;
import shaded.com.bash.riak.protobuf.RiakKvPB;
import shaded.com.google.protobuf.ByteString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiakLink {
    private final ByteString bucket;
    private final ByteString key;
    private final ByteString tag;

    RiakLink(RiakKvPB.RpbLink rpbLink) {
        this.bucket = rpbLink.getBucket();
        this.key = rpbLink.getKey();
        this.tag = rpbLink.getTag();
    }

    public RiakLink(String bucket, String key, String tag) {
        this.bucket = ByteString.copyFromUtf8(bucket);
        this.key = ByteString.copyFromUtf8(key);
        this.tag = ByteString.copyFromUtf8(tag);
    }

    public RiakLink(ByteString bucket, ByteString key, ByteString tag) {
        this.bucket = bucket;
        this.key = key;
        this.tag = tag;
    }

    public static List<RiakLink> decode(List<RiakKvPB.RpbLink> list) {
        ArrayList<RiakLink> res = new ArrayList<RiakLink>();
        for (int i = 0; i < list.size(); ++i) {
            res.add(new RiakLink(list.get(i)));
        }
        return res;
    }

    public ByteString getBucket() {
        return this.bucket;
    }

    public ByteString getKey() {
        return this.key;
    }

    public ByteString getTag() {
        return this.tag;
    }

    public RiakKvPB.RpbLink build() {
        RiakKvPB.RpbLink.Builder b = RiakKvPB.RpbLink.newBuilder();
        if (this.bucket != null) {
            b.setBucket(this.bucket);
        }
        if (this.key != null) {
            b.setKey(this.key);
        }
        if (this.tag != null) {
            b.setTag(this.tag);
        }
        return b.build();
    }
}

