/*
 * Decompiled with CFR 0.152.
 */
package com.brinkus.labs.neo4j.health.unmanaged;

import com.brinkus.labs.neo4j.health.type.Health;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;

@Path(value="/health")
public class HealthResource {
    private static final int TIMEOUT = 1000;
    private static final String PING_CYPHER = "MATCH (n) RETURN count(*) as count";
    private final GraphDatabaseService service;
    private final ObjectMapper mapper;

    public HealthResource(@Context GraphDatabaseService service) {
        this.service = service;
        this.mapper = new ObjectMapper();
    }

    @GET
    @Produces(value={"application/json"})
    public Response health() throws JsonProcessingException {
        Health health = this.healthCheck();
        byte[] entity = this.mapper.writeValueAsBytes(health);
        return Response.ok().type(MediaType.APPLICATION_JSON_TYPE).entity((Object)entity).build();
    }

    private Health healthCheck() {
        try {
            if (!this.service.isAvailable(1000L)) {
                return new Health.Builder().down().withDetail("description", "Neo4j health check result was invalid!").build();
            }
            Result result = this.service.execute(PING_CYPHER);
            Long count = (Long)result.next().get("count");
            if (count == 0L) {
                return new Health.Builder().outOfService().withDetail("description", "Neo4j has no available node!").build();
            }
            return new Health.Builder().up().withDetail("description", "Neo4j health check was success.").build();
        }
        catch (Exception e) {
            return new Health.Builder().outOfService().withDetail("description", "Neo4j health check failed!").withException(e).build();
        }
    }
}

