/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.stream;

import com.clickhouse.data.ClickHouseByteBuffer;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.stream.AbstractByteArrayInputStream;
import java.io.IOException;
import java.util.Queue;

public class ByteArrayQueueInputStream
extends AbstractByteArrayInputStream {
    private final Queue<byte[]> queue;

    public ByteArrayQueueInputStream(Queue<byte[]> queue, Runnable postCloseAction) {
        super(null, null, postCloseAction);
        this.queue = ClickHouseChecker.nonNull(queue, "queue");
    }

    @Override
    protected int updateBuffer() throws IOException {
        this.position = 0;
        while (!this.queue.isEmpty()) {
            byte[] bytes = this.queue.poll();
            int len = bytes != null ? bytes.length : 0;
            if (len <= 0) continue;
            this.buffer = bytes;
            if (this.copyTo != null) {
                this.copyTo.write(bytes);
            }
            this.limit = len;
            return this.limit;
        }
        this.buffer = ClickHouseByteBuffer.EMPTY_BYTES;
        this.limit = 0;
        return 0;
    }
}

