/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.com.google.common.util.concurrent;

import com.clickhouse.client.internal.com.google.common.annotations.GwtCompatible;
import com.clickhouse.client.internal.com.google.common.collect.Sets;
import com.clickhouse.client.internal.com.google.common.util.concurrent.AbstractFuture;
import com.clickhouse.client.internal.com.google.common.util.concurrent.LazyLogger;
import com.clickhouse.client.internal.com.google.j2objc.annotations.ReflectionSupport;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Level;
import org.jspecify.annotations.Nullable;

@GwtCompatible(emulated=true)
@ReflectionSupport(value=ReflectionSupport.Level.FULL)
abstract class AggregateFutureState<OutputT>
extends AbstractFuture.TrustedFuture<OutputT> {
    private volatile @Nullable Set<Throwable> seenExceptions = null;
    private volatile int remaining;
    private static final AtomicHelper ATOMIC_HELPER;
    private static final LazyLogger log;

    AggregateFutureState(int remainingFutures) {
        this.remaining = remainingFutures;
    }

    final Set<Throwable> getOrInitSeenExceptions() {
        Set<Throwable> seenExceptionsLocal = this.seenExceptions;
        if (seenExceptionsLocal == null) {
            seenExceptionsLocal = Sets.newConcurrentHashSet();
            this.addInitialException(seenExceptionsLocal);
            ATOMIC_HELPER.compareAndSetSeenExceptions(this, null, seenExceptionsLocal);
            seenExceptionsLocal = Objects.requireNonNull(this.seenExceptions);
        }
        return seenExceptionsLocal;
    }

    abstract void addInitialException(Set<Throwable> var1);

    final int decrementRemainingAndGet() {
        return ATOMIC_HELPER.decrementAndGetRemainingCount(this);
    }

    final void clearSeenExceptions() {
        this.seenExceptions = null;
    }

    private static AtomicReferenceFieldUpdater<? super AggregateFutureState<?>, ? super @Nullable Set<Throwable>> seenExceptionsUpdaterFromWithinAggregateFutureState() {
        return AtomicReferenceFieldUpdater.newUpdater(AggregateFutureState.class, Set.class, "seenExceptions");
    }

    private static AtomicIntegerFieldUpdater<? super AggregateFutureState<?>> remainingCountUpdaterFromWithinAggregateFutureState() {
        return AtomicIntegerFieldUpdater.newUpdater(AggregateFutureState.class, "remaining");
    }

    static /* synthetic */ AtomicReferenceFieldUpdater access$300() {
        return AggregateFutureState.seenExceptionsUpdaterFromWithinAggregateFutureState();
    }

    static /* synthetic */ AtomicIntegerFieldUpdater access$400() {
        return AggregateFutureState.remainingCountUpdaterFromWithinAggregateFutureState();
    }

    static {
        AtomicHelper helper;
        log = new LazyLogger(AggregateFutureState.class);
        Throwable thrownReflectionFailure = null;
        try {
            helper = new SafeAtomicHelper();
        }
        catch (Throwable reflectionFailure) {
            thrownReflectionFailure = reflectionFailure;
            helper = new SynchronizedAtomicHelper();
        }
        ATOMIC_HELPER = helper;
        if (thrownReflectionFailure != null) {
            log.get().log(Level.SEVERE, "SafeAtomicHelper is broken!", thrownReflectionFailure);
        }
    }

    private static abstract class AtomicHelper {
        private AtomicHelper() {
        }

        abstract void compareAndSetSeenExceptions(AggregateFutureState<?> var1, @Nullable Set<Throwable> var2, Set<Throwable> var3);

        abstract int decrementAndGetRemainingCount(AggregateFutureState<?> var1);
    }

    private static final class SafeAtomicHelper
    extends AtomicHelper {
        private static final AtomicReferenceFieldUpdater<? super AggregateFutureState<?>, ? super @Nullable Set<Throwable>> seenExceptionsUpdater = AggregateFutureState.access$300();
        private static final AtomicIntegerFieldUpdater<? super AggregateFutureState<?>> remainingCountUpdater = AggregateFutureState.access$400();

        private SafeAtomicHelper() {
        }

        @Override
        void compareAndSetSeenExceptions(AggregateFutureState<?> state, @Nullable Set<Throwable> expect, Set<Throwable> update) {
            seenExceptionsUpdater.compareAndSet(state, expect, update);
        }

        @Override
        int decrementAndGetRemainingCount(AggregateFutureState<?> state) {
            return remainingCountUpdater.decrementAndGet(state);
        }
    }

    private static final class SynchronizedAtomicHelper
    extends AtomicHelper {
        private SynchronizedAtomicHelper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void compareAndSetSeenExceptions(AggregateFutureState<?> state, @Nullable Set<Throwable> expect, Set<Throwable> update) {
            AggregateFutureState<?> aggregateFutureState = state;
            synchronized (aggregateFutureState) {
                if (((AggregateFutureState)state).seenExceptions == expect) {
                    ((AggregateFutureState)state).seenExceptions = update;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        int decrementAndGetRemainingCount(AggregateFutureState<?> state) {
            AggregateFutureState<?> aggregateFutureState = state;
            synchronized (aggregateFutureState) {
                return --((AggregateFutureState)state).remaining;
            }
        }
    }
}

