/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.core.oauth;

import com.databricks.internal.sdk.core.CredentialsProvider;
import com.databricks.internal.sdk.core.DatabricksConfig;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.oauth.CachedTokenSource;
import com.databricks.internal.sdk.core.oauth.Consent;
import com.databricks.internal.sdk.core.oauth.FileTokenCache;
import com.databricks.internal.sdk.core.oauth.OAuthClient;
import com.databricks.internal.sdk.core.oauth.OAuthClientUtils;
import com.databricks.internal.sdk.core.oauth.OAuthHeaderFactory;
import com.databricks.internal.sdk.core.oauth.SessionCredentialsTokenSource;
import com.databricks.internal.sdk.core.oauth.Token;
import com.databricks.internal.sdk.core.oauth.TokenCache;
import com.databricks.internal.sdk.core.oauth.TokenCacheUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalBrowserCredentialsProvider
implements CredentialsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalBrowserCredentialsProvider.class);
    private TokenCache tokenCache;

    public ExternalBrowserCredentialsProvider(TokenCache tokenCache) {
        this.tokenCache = tokenCache;
    }

    public ExternalBrowserCredentialsProvider() {
        this(null);
    }

    @Override
    public String authType() {
        return "external-browser";
    }

    @Override
    public OAuthHeaderFactory configure(DatabricksConfig config) {
        if (config.getHost() == null || !Objects.equals(config.getAuthType(), "external-browser")) {
            return null;
        }
        String clientId = OAuthClientUtils.resolveClientId(config);
        String clientSecret = OAuthClientUtils.resolveClientSecret(config);
        try {
            Token cachedToken;
            if (this.tokenCache == null) {
                Path cachePath = TokenCacheUtils.getCacheFilePath(config.getHost(), clientId, config.getScopes());
                this.tokenCache = new FileTokenCache(cachePath);
            }
            if ((cachedToken = this.tokenCache.load()) != null && cachedToken.getRefreshToken() != null) {
                LOGGER.debug("Found cached token for {}:{}", (Object)config.getHost(), (Object)clientId);
                try {
                    SessionCredentialsTokenSource tokenSource = new SessionCredentialsTokenSource(cachedToken, config.getHttpClient(), config.getOidcEndpoints().getTokenEndpoint(), clientId, clientSecret, Optional.of(config.getEffectiveOAuthRedirectUrl()), Optional.of(this.tokenCache));
                    CachedTokenSource cachedTokenSource = new CachedTokenSource.Builder(tokenSource).setAsyncDisabled(config.getDisableAsyncTokenRefresh()).build();
                    LOGGER.debug("Using cached token, will immediately refresh");
                    cachedTokenSource.getToken();
                    return OAuthHeaderFactory.fromTokenSource(cachedTokenSource);
                }
                catch (Exception e) {
                    LOGGER.info("Token refresh failed: {}, falling back to browser auth", (Object)e.getMessage());
                }
            }
            CachedTokenSource cachedTokenSource = this.performBrowserAuth(config, clientId, clientSecret, this.tokenCache);
            this.tokenCache.save(cachedTokenSource.getToken());
            return OAuthHeaderFactory.fromTokenSource(cachedTokenSource);
        }
        catch (DatabricksException | IOException e) {
            LOGGER.error("Failed to authenticate: {}", (Object)e.getMessage());
            return null;
        }
    }

    CachedTokenSource performBrowserAuth(DatabricksConfig config, String clientId, String clientSecret, TokenCache tokenCache) throws IOException {
        LOGGER.debug("Performing browser authentication");
        HashSet<String> scopes = new HashSet<String>(config.getScopes());
        scopes.add("offline_access");
        if (config.isAzure()) {
            scopes.add(config.getEffectiveAzureLoginAppId() + "/user_impersonation");
        }
        OAuthClient client = new OAuthClient.Builder().withHttpClient(config.getHttpClient()).withClientId(clientId).withClientSecret(clientSecret).withHost(config.getHost()).withAccountId(config.getAccountId()).withRedirectUrl(config.getEffectiveOAuthRedirectUrl()).withBrowserTimeout(config.getOAuthBrowserAuthTimeout()).withScopes(new ArrayList<String>(scopes)).withOpenIDConnectEndpoints(config.getOidcEndpoints()).build();
        Consent consent = client.initiateConsent();
        Token token = consent.getTokenFromExternalBrowser();
        SessionCredentialsTokenSource tokenSource = new SessionCredentialsTokenSource(token, config.getHttpClient(), config.getOidcEndpoints().getTokenEndpoint(), config.getClientId(), config.getClientSecret(), Optional.ofNullable(config.getEffectiveOAuthRedirectUrl()), Optional.ofNullable(tokenCache));
        return new CachedTokenSource.Builder(tokenSource).setToken(token).setAsyncDisabled(config.getDisableAsyncTokenRefresh()).build();
    }
}

