/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.catalog;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.catalog.CreateRegisteredModelRequest;
import com.databricks.internal.sdk.service.catalog.DeleteAliasRequest;
import com.databricks.internal.sdk.service.catalog.DeleteRegisteredModelRequest;
import com.databricks.internal.sdk.service.catalog.GetRegisteredModelRequest;
import com.databricks.internal.sdk.service.catalog.ListRegisteredModelsRequest;
import com.databricks.internal.sdk.service.catalog.ListRegisteredModelsResponse;
import com.databricks.internal.sdk.service.catalog.RegisteredModelAlias;
import com.databricks.internal.sdk.service.catalog.RegisteredModelInfo;
import com.databricks.internal.sdk.service.catalog.RegisteredModelsImpl;
import com.databricks.internal.sdk.service.catalog.RegisteredModelsService;
import com.databricks.internal.sdk.service.catalog.SetRegisteredModelAliasRequest;
import com.databricks.internal.sdk.service.catalog.UpdateRegisteredModelRequest;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class RegisteredModelsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(RegisteredModelsAPI.class);
    private final RegisteredModelsService impl;

    public RegisteredModelsAPI(ApiClient apiClient) {
        this.impl = new RegisteredModelsImpl(apiClient);
    }

    public RegisteredModelsAPI(RegisteredModelsService mock) {
        this.impl = mock;
    }

    public RegisteredModelInfo create(CreateRegisteredModelRequest request) {
        return this.impl.create(request);
    }

    public void delete(String fullName) {
        this.delete(new DeleteRegisteredModelRequest().setFullName(fullName));
    }

    public void delete(DeleteRegisteredModelRequest request) {
        this.impl.delete(request);
    }

    public void deleteAlias(String fullName, String alias) {
        this.deleteAlias(new DeleteAliasRequest().setFullName(fullName).setAlias(alias));
    }

    public void deleteAlias(DeleteAliasRequest request) {
        this.impl.deleteAlias(request);
    }

    public RegisteredModelInfo get(String fullName) {
        return this.get(new GetRegisteredModelRequest().setFullName(fullName));
    }

    public RegisteredModelInfo get(GetRegisteredModelRequest request) {
        return this.impl.get(request);
    }

    public Iterable<RegisteredModelInfo> list(ListRegisteredModelsRequest request) {
        return new Paginator(request, this.impl::list, ListRegisteredModelsResponse::getRegisteredModels, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public RegisteredModelAlias setAlias(SetRegisteredModelAliasRequest request) {
        return this.impl.setAlias(request);
    }

    public RegisteredModelInfo update(UpdateRegisteredModelRequest request) {
        return this.impl.update(request);
    }

    public RegisteredModelsService impl() {
        return this.impl;
    }
}

