/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.iam;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.iam.AccountServicePrincipalsImpl;
import com.databricks.internal.sdk.service.iam.AccountServicePrincipalsService;
import com.databricks.internal.sdk.service.iam.DeleteAccountServicePrincipalRequest;
import com.databricks.internal.sdk.service.iam.GetAccountServicePrincipalRequest;
import com.databricks.internal.sdk.service.iam.ListAccountServicePrincipalsRequest;
import com.databricks.internal.sdk.service.iam.ListServicePrincipalResponse;
import com.databricks.internal.sdk.service.iam.PartialUpdate;
import com.databricks.internal.sdk.service.iam.ServicePrincipal;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class AccountServicePrincipalsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(AccountServicePrincipalsAPI.class);
    private final AccountServicePrincipalsService impl;

    public AccountServicePrincipalsAPI(ApiClient apiClient) {
        this.impl = new AccountServicePrincipalsImpl(apiClient);
    }

    public AccountServicePrincipalsAPI(AccountServicePrincipalsService mock) {
        this.impl = mock;
    }

    public ServicePrincipal create(ServicePrincipal request) {
        return this.impl.create(request);
    }

    public void delete(String id) {
        this.delete(new DeleteAccountServicePrincipalRequest().setId(id));
    }

    public void delete(DeleteAccountServicePrincipalRequest request) {
        this.impl.delete(request);
    }

    public ServicePrincipal get(String id) {
        return this.get(new GetAccountServicePrincipalRequest().setId(id));
    }

    public ServicePrincipal get(GetAccountServicePrincipalRequest request) {
        return this.impl.get(request);
    }

    public Iterable<ServicePrincipal> list(ListAccountServicePrincipalsRequest request) {
        request.setStartIndex(1L);
        if (request.getCount() == null) {
            request.setCount(10000L);
        }
        return new Paginator<ListAccountServicePrincipalsRequest, ListServicePrincipalResponse, ServicePrincipal>(request, this.impl::list, ListServicePrincipalResponse::getResources, response -> {
            Long offset = request.getStartIndex();
            if (offset == null) {
                offset = 0L;
            }
            offset = offset + (long)response.getResources().size();
            return request.setStartIndex(offset);
        }).withDedupe(ServicePrincipal::getId);
    }

    public void patch(PartialUpdate request) {
        this.impl.patch(request);
    }

    public void update(ServicePrincipal request) {
        this.impl.update(request);
    }

    public AccountServicePrincipalsService impl() {
        return this.impl;
    }
}

