/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.sql;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.sql.Dashboard;
import com.databricks.internal.sdk.service.sql.DashboardEditContent;
import com.databricks.internal.sdk.service.sql.DashboardsService;
import com.databricks.internal.sdk.service.sql.DeleteDashboardRequest;
import com.databricks.internal.sdk.service.sql.GetDashboardRequest;
import com.databricks.internal.sdk.service.sql.ListDashboardsRequest;
import com.databricks.internal.sdk.service.sql.ListResponse;
import com.databricks.internal.sdk.service.sql.RestoreDashboardRequest;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class DashboardsImpl
implements DashboardsService {
    private final ApiClient apiClient;

    public DashboardsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void delete(DeleteDashboardRequest request) {
        String path = String.format("/api/2.0/preview/sql/dashboards/%s", request.getDashboardId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Dashboard get(GetDashboardRequest request) {
        String path = String.format("/api/2.0/preview/sql/dashboards/%s", request.getDashboardId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, Dashboard.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListResponse list(ListDashboardsRequest request) {
        String path = "/api/2.0/preview/sql/dashboards";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void restore(RestoreDashboardRequest request) {
        String path = String.format("/api/2.0/preview/sql/dashboards/trash/%s", request.getDashboardId());
        try {
            Request req = new Request("POST", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Dashboard update(DashboardEditContent request) {
        String path = String.format("/api/2.0/preview/sql/dashboards/%s", request.getDashboardId());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, Dashboard.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

