/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.volume;

import com.databricks.internal.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import com.databricks.internal.apache.hc.client5.http.async.methods.SimpleResponseConsumer;
import com.databricks.internal.apache.hc.core5.concurrent.FutureCallback;
import com.databricks.internal.apache.hc.core5.http.ContentType;
import com.databricks.internal.apache.hc.core5.http.nio.AsyncRequestProducer;
import com.databricks.internal.apache.hc.core5.http.nio.entity.AsyncEntityProducers;
import com.databricks.internal.apache.hc.core5.http.nio.support.AsyncRequestBuilder;
import com.databricks.jdbc.api.impl.VolumeOperationStatus;
import com.databricks.jdbc.api.impl.volume.DBFSVolumeClient;
import com.databricks.jdbc.api.impl.volume.InputStreamFixedLenProducer;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.common.util.VolumeRetryUtil;
import com.databricks.jdbc.dbclient.IDatabricksHttpClient;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.client.filesystem.CreateUploadUrlResponse;
import com.databricks.jdbc.model.client.filesystem.VolumePutResult;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class VolumeUploadCallback
implements FutureCallback<SimpleHttpResponse> {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(VolumeUploadCallback.class);
    private final IDatabricksHttpClient httpClient;
    private final CompletableFuture<VolumePutResult> uploadFuture;
    private final DBFSVolumeClient.UploadRequest request;
    private final Semaphore semaphore;
    private final int attempt;
    private final UrlGenerator urlGenerator;
    private final Function<Integer, Long> retryDelayCalculator;
    private final IDatabricksConnectionContext connectionContext;
    private final long retryStartTime;

    public VolumeUploadCallback(IDatabricksHttpClient httpClient, CompletableFuture<VolumePutResult> uploadFuture, DBFSVolumeClient.UploadRequest request, Semaphore semaphore, UrlGenerator urlGenerator, Function<Integer, Long> retryDelayCalculator, IDatabricksConnectionContext connectionContext) {
        this(httpClient, uploadFuture, request, semaphore, urlGenerator, retryDelayCalculator, connectionContext, 1, System.currentTimeMillis());
    }

    private VolumeUploadCallback(IDatabricksHttpClient httpClient, CompletableFuture<VolumePutResult> uploadFuture, DBFSVolumeClient.UploadRequest request, Semaphore semaphore, UrlGenerator urlGenerator, Function<Integer, Long> retryDelayCalculator, IDatabricksConnectionContext connectionContext, int attempt, long retryStartTime) {
        this.httpClient = httpClient;
        this.uploadFuture = uploadFuture;
        this.request = request;
        this.semaphore = semaphore;
        this.urlGenerator = urlGenerator;
        this.retryDelayCalculator = retryDelayCalculator;
        this.connectionContext = connectionContext;
        this.attempt = attempt;
        this.retryStartTime = retryStartTime;
    }

    @Override
    public void completed(SimpleHttpResponse uploadResult) {
        if (uploadResult.getCode() >= 200 && uploadResult.getCode() < 300) {
            VolumeOperationStatus status = VolumeOperationStatus.SUCCEEDED;
            this.uploadFuture.complete(new VolumePutResult(uploadResult.getCode(), status, null));
        } else if (VolumeRetryUtil.isRetryableHttpCode(uploadResult.getCode(), this.connectionContext) && VolumeRetryUtil.shouldRetry(this.attempt, this.retryStartTime, this.connectionContext)) {
            long retryDelayMs = this.retryDelayCalculator.apply(this.attempt);
            long elapsedSeconds = (System.currentTimeMillis() - this.retryStartTime) / 1000L;
            int timeoutSeconds = VolumeRetryUtil.getRetryTimeoutSeconds(this.connectionContext);
            LOGGER.warn("Upload failed for {}: HTTP {} - {}. Retrying in {} ms (elapsed: {}s, timeout: {}s)", this.request.objectPath, uploadResult.getCode(), uploadResult.getReasonPhrase(), retryDelayMs, elapsedSeconds, timeoutSeconds);
            this.retry(retryDelayMs);
        } else {
            VolumeOperationStatus status = VolumeOperationStatus.FAILED;
            String message = uploadResult.getReasonPhrase();
            LOGGER.error("Upload failed for {}: HTTP {} - {}", this.request.objectPath, uploadResult.getCode(), message);
            this.uploadFuture.complete(new VolumePutResult(uploadResult.getCode(), status, message));
        }
    }

    @Override
    public void failed(Exception ex) {
        if (VolumeRetryUtil.shouldRetry(this.attempt, this.retryStartTime, this.connectionContext)) {
            long retryDelayMs = this.retryDelayCalculator.apply(this.attempt);
            long elapsedSeconds = (System.currentTimeMillis() - this.retryStartTime) / 1000L;
            int timeoutSeconds = VolumeRetryUtil.getRetryTimeoutSeconds(this.connectionContext);
            LOGGER.warn("Upload failed for {}: {}. Retrying in {} ms (elapsed: {}s, timeout: {}s)", this.request.objectPath, ex.getMessage(), retryDelayMs, elapsedSeconds, timeoutSeconds);
            this.retry(retryDelayMs);
        } else {
            LOGGER.error(ex, "Upload failed for {}: {}", this.request.objectPath, ex.getMessage());
            this.uploadFuture.complete(new VolumePutResult(500, VolumeOperationStatus.FAILED, ex.getMessage()));
        }
    }

    @Override
    public void cancelled() {
        LOGGER.warn("Upload cancelled for {}", this.request.objectPath);
        this.uploadFuture.complete(new VolumePutResult(499, VolumeOperationStatus.ABORTED, "Upload cancelled"));
    }

    private void retry(long delayMs) {
        CompletableFuture.delayedExecutor(delayMs, TimeUnit.MILLISECONDS).execute(() -> {
            if (!this.request.isFile() && this.request.inputStream.markSupported()) {
                try {
                    this.request.inputStream.reset();
                }
                catch (IOException e2) {
                    LOGGER.warn("Could not reset input stream for retry: " + e2.getMessage());
                }
            }
            ((CompletableFuture)this.urlGenerator.apply(this.request.ucVolumePath, this.request.objectPath, 1).thenAccept(response -> {
                String presignedUrl = response.getUrl();
                LOGGER.debug("Got new presigned URL for retry of {} (attempt {})", this.request.objectPath, this.attempt + 1);
                try {
                    AsyncRequestProducer uploadProducer;
                    if (this.request.isFile()) {
                        uploadProducer = AsyncRequestBuilder.put().setUri(URI.create(presignedUrl)).setEntity(AsyncEntityProducers.create(this.request.file.toFile(), ContentType.DEFAULT_BINARY)).build();
                    } else {
                        InputStreamFixedLenProducer entity = new InputStreamFixedLenProducer(this.request.inputStream, this.request.contentLength);
                        uploadProducer = AsyncRequestBuilder.put().setUri(URI.create(presignedUrl)).setEntity(entity).build();
                    }
                    SimpleResponseConsumer uploadConsumer = SimpleResponseConsumer.create();
                    VolumeUploadCallback uploadCallback = new VolumeUploadCallback(this.httpClient, this.uploadFuture, this.request, this.semaphore, this.urlGenerator, this.retryDelayCalculator, this.connectionContext, this.attempt + 1, this.retryStartTime);
                    this.httpClient.executeAsync(uploadProducer, uploadConsumer, uploadCallback);
                }
                catch (Exception e) {
                    String errorMessage = "Error setting up retry for " + this.request.objectPath + ": " + e.getMessage();
                    LOGGER.error(e, errorMessage);
                    this.uploadFuture.complete(new VolumePutResult(500, VolumeOperationStatus.FAILED, errorMessage));
                }
            })).exceptionally(e -> {
                String errorMessage = "Failed to get presigned URL for retry of " + this.request.objectPath + ": " + e.getMessage();
                LOGGER.error((Throwable)e, errorMessage);
                this.uploadFuture.complete(new VolumePutResult(500, VolumeOperationStatus.FAILED, errorMessage));
                return null;
            });
        });
    }

    @FunctionalInterface
    public static interface UrlGenerator {
        public CompletableFuture<CreateUploadUrlResponse> apply(String var1, String var2, int var3);
    }
}

