/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.common.safe;

import com.databricks.internal.google.common.annotations.VisibleForTesting;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.common.safe.DatabricksDriverFeatureFlagsContext;
import com.databricks.jdbc.common.safe.FeatureFlagsContextHolder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DatabricksDriverFeatureFlagsContextFactory {
    private static final Map<String, FeatureFlagsContextHolder> contextMap = new ConcurrentHashMap<String, FeatureFlagsContextHolder>();

    private DatabricksDriverFeatureFlagsContextFactory() {
    }

    public static DatabricksDriverFeatureFlagsContext getInstance(IDatabricksConnectionContext context) {
        String key = DatabricksDriverFeatureFlagsContextFactory.keyOf(context);
        FeatureFlagsContextHolder holder = contextMap.compute(key, (k, existing) -> {
            if (existing == null) {
                return new FeatureFlagsContextHolder(new DatabricksDriverFeatureFlagsContext(context), 1);
            }
            existing.refCount.incrementAndGet();
            return existing;
        });
        return holder.context;
    }

    public static void removeInstance(IDatabricksConnectionContext connectionContext) {
        if (connectionContext != null) {
            String key = DatabricksDriverFeatureFlagsContextFactory.keyOf(connectionContext);
            contextMap.computeIfPresent(key, (k, holder) -> {
                if (holder.refCount.get() <= 1) {
                    holder.context.shutdown();
                    return null;
                }
                holder.refCount.decrementAndGet();
                return holder;
            });
        }
    }

    @VisibleForTesting
    static void setFeatureFlagsContext(IDatabricksConnectionContext connectionContext, Map<String, String> featureFlags) {
        String key = DatabricksDriverFeatureFlagsContextFactory.keyOf(connectionContext);
        contextMap.put(key, new FeatureFlagsContextHolder(new DatabricksDriverFeatureFlagsContext(connectionContext, featureFlags), 1));
    }

    private static String keyOf(IDatabricksConnectionContext context) {
        return context.getComputeResource().getUniqueIdentifier();
    }
}

