/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.api;

import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import com.datastax.oss.dsbulk.codecs.api.ConversionContext;
import com.datastax.oss.dsbulk.codecs.api.format.binary.Base64BinaryFormat;
import com.datastax.oss.dsbulk.codecs.api.format.binary.BinaryFormat;
import com.datastax.oss.dsbulk.codecs.api.format.geo.GeoFormat;
import com.datastax.oss.dsbulk.codecs.api.format.temporal.TemporalFormat;
import com.datastax.oss.dsbulk.codecs.api.util.CodecUtils;
import com.datastax.oss.dsbulk.codecs.api.util.OverflowStrategy;
import com.datastax.oss.dsbulk.codecs.api.util.TimeUUIDGenerator;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.netty.util.concurrent.FastThreadLocal;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class CommonConversionContext
extends ConversionContext {
    private static final Map<String, Boolean> DEFAULT_BOOLEAN_INPUT_WORDS = ImmutableMap.builder().put((Object)"1", (Object)true).put((Object)"0", (Object)false).put((Object)"y", (Object)true).put((Object)"n", (Object)false).put((Object)"t", (Object)true).put((Object)"f", (Object)false).put((Object)"yes", (Object)true).put((Object)"no", (Object)false).put((Object)"true", (Object)true).put((Object)"false", (Object)false).build();
    private static final Map<Boolean, String> DEFAULT_BOOLEAN_OUTPUT_WORDS = ImmutableMap.of((Object)true, (Object)"1", (Object)false, (Object)"0");
    public static final String LOCALE = "LOCALE";
    public static final String FORMAT_NUMBERS = "FORMAT_NUMBERS";
    public static final String NULL_STRINGS = "NULL_STRINGS";
    public static final String NUMERIC_PATTERN = "NUMERIC_PATTERN";
    public static final String NUMBER_FORMAT = "NUMBER_FORMAT";
    public static final String OVERFLOW_STRATEGY = "OVERFLOW_STRATEGY";
    public static final String ROUNDING_MODE = "ROUNDING_MODE";
    public static final String TIMESTAMP_PATTERN = "TIMESTAMP_PATTERN";
    public static final String DATE_PATTERN = "DATE_PATTERN";
    public static final String TIME_PATTERN = "TIME_PATTERN";
    public static final String TIMESTAMP_FORMAT = "TIMESTAMP_FORMAT";
    public static final String LOCAL_DATE_FORMAT = "LOCAL_DATE_FORMAT";
    public static final String LOCAL_TIME_FORMAT = "LOCAL_TIME_FORMAT";
    public static final String TIME_ZONE = "TIME_ZONE";
    public static final String TIME_UNIT = "TIME_UNIT";
    public static final String EPOCH = "EPOCH";
    public static final String BOOLEAN_INPUT_WORDS = "BOOLEAN_INPUT_WORDS";
    public static final String BOOLEAN_OUTPUT_WORDS = "BOOLEAN_OUTPUT_WORDS";
    public static final String BOOLEAN_NUMBERS = "BOOLEAN_NUMBERS";
    public static final String TIME_UUID_GENERATOR = "TIME_UUID_GENERATOR";
    public static final String BINARY_FORMAT = "BINARY_FORMAT";
    public static final String GEO_FORMAT = "GEO_FORMAT";
    public static final String ALLOW_EXTRA_FIELDS = "ALLOW_EXTRA_FIELDS";
    public static final String ALLOW_MISSING_FIELDS = "ALLOW_MISSING_FIELDS";

    public CommonConversionContext() {
        this.addAttribute(LOCALE, Locale.US);
        this.addAttribute(TIME_ZONE, ZoneOffset.UTC);
        this.addAttribute(FORMAT_NUMBERS, false);
        this.addAttribute(ROUNDING_MODE, (Object)RoundingMode.UNNECESSARY);
        this.addAttribute(OVERFLOW_STRATEGY, (Object)OverflowStrategy.REJECT);
        this.addAttribute(TIME_UNIT, (Object)TimeUnit.MILLISECONDS);
        this.addAttribute(EPOCH, Instant.EPOCH.atZone(ZoneOffset.UTC));
        this.addAttribute(TIME_UUID_GENERATOR, (Object)TimeUUIDGenerator.RANDOM);
        this.addAttribute(NUMERIC_PATTERN, "#,###.##");
        this.addAttribute(TIMESTAMP_PATTERN, "CQL_TIMESTAMP");
        this.addAttribute(DATE_PATTERN, "ISO_LOCAL_DATE");
        this.addAttribute(TIME_PATTERN, "ISO_LOCAL_TIME");
        this.addAttribute(NULL_STRINGS, new ArrayList());
        this.addAttribute(BOOLEAN_INPUT_WORDS, DEFAULT_BOOLEAN_INPUT_WORDS);
        this.addAttribute(BOOLEAN_OUTPUT_WORDS, DEFAULT_BOOLEAN_OUTPUT_WORDS);
        this.addAttribute(BOOLEAN_NUMBERS, Lists.newArrayList((Object[])new BigDecimal[]{BigDecimal.ONE, BigDecimal.ZERO}));
        this.addAttribute(ALLOW_EXTRA_FIELDS, false);
        this.addAttribute(ALLOW_MISSING_FIELDS, false);
        this.addAttribute(BINARY_FORMAT, Base64BinaryFormat.INSTANCE);
        this.rebuildFormats();
    }

    public CommonConversionContext setLocale(@NonNull Locale locale) {
        this.addAttribute(LOCALE, Objects.requireNonNull(locale));
        this.rebuildFormats();
        return this;
    }

    public CommonConversionContext setTimeZone(@NonNull ZoneId timeZone) {
        this.addAttribute(TIME_ZONE, Objects.requireNonNull(timeZone));
        this.rebuildFormats();
        return this;
    }

    public CommonConversionContext setFormatNumbers(boolean formatNumbers) {
        this.addAttribute(FORMAT_NUMBERS, formatNumbers);
        this.rebuildFormats();
        return this;
    }

    public CommonConversionContext setRoundingMode(@NonNull RoundingMode roundingMode) {
        this.addAttribute(ROUNDING_MODE, (Object)roundingMode);
        this.rebuildFormats();
        return this;
    }

    public CommonConversionContext setOverflowStrategy(@NonNull OverflowStrategy overflowStrategy) {
        this.addAttribute(OVERFLOW_STRATEGY, (Object)overflowStrategy);
        this.rebuildFormats();
        return this;
    }

    public CommonConversionContext setTimeUnit(@NonNull TimeUnit unit) {
        this.addAttribute(TIME_UNIT, (Object)unit);
        this.rebuildFormats();
        return this;
    }

    public CommonConversionContext setEpoch(@NonNull ZonedDateTime epoch) {
        this.addAttribute(EPOCH, epoch);
        this.rebuildFormats();
        return this;
    }

    public CommonConversionContext setTimeUUIDGenerator(@NonNull TimeUUIDGenerator uuidGenerator) {
        this.addAttribute(TIME_UUID_GENERATOR, (Object)uuidGenerator);
        return this;
    }

    public CommonConversionContext setNumberFormat(@NonNull String numberFormat) {
        this.addAttribute(NUMERIC_PATTERN, numberFormat);
        this.rebuildFormats();
        return this;
    }

    public CommonConversionContext setTimestampFormat(@NonNull String timestampFormat) {
        this.addAttribute(TIMESTAMP_PATTERN, timestampFormat);
        this.rebuildFormats();
        return this;
    }

    public CommonConversionContext setDateFormat(@NonNull String dateFormat) {
        this.addAttribute(DATE_PATTERN, dateFormat);
        this.rebuildFormats();
        return this;
    }

    public CommonConversionContext setTimeFormat(@NonNull String timeFormat) {
        this.addAttribute(TIME_PATTERN, timeFormat);
        this.rebuildFormats();
        return this;
    }

    public CommonConversionContext setBooleanInputWords(@NonNull Map<String, Boolean> inputWords) {
        this.addAttribute(BOOLEAN_INPUT_WORDS, Objects.requireNonNull(inputWords));
        return this;
    }

    public CommonConversionContext setBooleanOutputWords(@NonNull Map<Boolean, String> outputWords) {
        this.addAttribute(BOOLEAN_OUTPUT_WORDS, Objects.requireNonNull(outputWords));
        return this;
    }

    public CommonConversionContext setNullStrings(@NonNull List<String> nullStrings) {
        this.addAttribute(NULL_STRINGS, nullStrings);
        this.rebuildFormats();
        return this;
    }

    public CommonConversionContext setNullStrings(String ... nullStrings) {
        return this.setNullStrings(Arrays.asList(Objects.requireNonNull(nullStrings)));
    }

    public CommonConversionContext setBooleanNumbers(@NonNull BigDecimal trueNumber, BigDecimal falseNumber) {
        this.addAttribute(BOOLEAN_NUMBERS, Lists.newArrayList((Object[])new BigDecimal[]{trueNumber, falseNumber}));
        return this;
    }

    public CommonConversionContext setAllowExtraFields(boolean allowExtraFields) {
        this.addAttribute(ALLOW_EXTRA_FIELDS, allowExtraFields);
        return this;
    }

    public CommonConversionContext setAllowMissingFields(boolean allowMissingFields) {
        this.addAttribute(ALLOW_MISSING_FIELDS, allowMissingFields);
        return this;
    }

    public CommonConversionContext setBinaryFormat(@NonNull BinaryFormat binaryFormat) {
        this.addAttribute(BINARY_FORMAT, binaryFormat);
        return this;
    }

    public CommonConversionContext setGeoFormat(@NonNull GeoFormat binaryFormat) {
        this.addAttribute(GEO_FORMAT, binaryFormat);
        return this;
    }

    private void rebuildFormats() {
        String numericPattern = (String)this.getAttribute(NUMERIC_PATTERN);
        String timestampPattern = (String)this.getAttribute(TIMESTAMP_PATTERN);
        String datePattern = (String)this.getAttribute(DATE_PATTERN);
        String timePattern = (String)this.getAttribute(TIME_PATTERN);
        Locale locale = (Locale)this.getAttribute(LOCALE);
        ZoneId timeZone = (ZoneId)this.getAttribute(TIME_ZONE);
        TimeUnit timeUnit = (TimeUnit)((Object)this.getAttribute(TIME_UNIT));
        ZonedDateTime epoch = (ZonedDateTime)this.getAttribute(EPOCH);
        RoundingMode roundingMode = (RoundingMode)((Object)this.getAttribute(ROUNDING_MODE));
        boolean formatNumbers = (Boolean)this.getAttribute(FORMAT_NUMBERS);
        FastThreadLocal<NumberFormat> numberFormat = CodecUtils.getNumberFormatThreadLocal(numericPattern, locale, roundingMode, formatNumbers);
        TemporalFormat dateFormat = CodecUtils.getTemporalFormat(datePattern, timeZone, locale, timeUnit, epoch, numberFormat, false);
        TemporalFormat timeFormat = CodecUtils.getTemporalFormat(timePattern, timeZone, locale, timeUnit, epoch, numberFormat, false);
        TemporalFormat timestampFormat = CodecUtils.getTemporalFormat(timestampPattern, timeZone, locale, timeUnit, epoch, numberFormat, true);
        this.addAttribute(NUMBER_FORMAT, numberFormat);
        this.addAttribute(LOCAL_DATE_FORMAT, dateFormat);
        this.addAttribute(LOCAL_TIME_FORMAT, timeFormat);
        this.addAttribute(TIMESTAMP_FORMAT, timestampFormat);
    }
}

