/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.api.format.temporal;

import com.datastax.oss.dsbulk.codecs.api.format.temporal.ZonedTemporalFormat;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.ZoneId;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;

public class CqlTemporalFormat
extends ZonedTemporalFormat {
    public static final CqlTemporalFormat DEFAULT_INSTANCE = new CqlTemporalFormat(ZoneId.of("UTC"));

    public CqlTemporalFormat(@NonNull ZoneId timeZone) {
        super(CqlTemporalFormat.createParser(), CqlTemporalFormat.createFormatter(timeZone), timeZone);
    }

    @NonNull
    private static DateTimeFormatter createParser() {
        return new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().optionalStart().appendLiteral('T').optionalEnd().optionalStart().appendLiteral(' ').optionalEnd().append(DateTimeFormatter.ISO_LOCAL_TIME).optionalEnd().optionalStart().appendLiteral(' ').appendZoneText(TextStyle.SHORT).optionalEnd().optionalStart().appendOffset("+HH:MM", "Z").optionalEnd().optionalStart().appendOffset("+HHmm", "Z").optionalEnd().parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).parseDefaulting(ChronoField.NANO_OF_SECOND, 0L).toFormatter().withLocale(Locale.US).withResolverStyle(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);
    }

    @NonNull
    private static DateTimeFormatter createFormatter(ZoneId timeZone) {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.withLocale(Locale.US).withResolverStyle(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE).withZone(timeZone);
    }
}

