/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.api.format.temporal;

import com.datastax.oss.dsbulk.codecs.api.format.temporal.TemporalFormat;
import java.text.ParsePosition;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;

public class SimpleTemporalFormat
implements TemporalFormat {
    private final DateTimeFormatter parser;
    private final DateTimeFormatter formatter;

    public SimpleTemporalFormat(DateTimeFormatter parserAndFormatter) {
        this(parserAndFormatter, parserAndFormatter);
    }

    public SimpleTemporalFormat(DateTimeFormatter parser, DateTimeFormatter formatter) {
        this.parser = Objects.requireNonNull(parser, "parser cannot be null");
        this.formatter = Objects.requireNonNull(formatter, "formatter cannot be null");
    }

    @Override
    public TemporalAccessor parse(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ParsePosition pos = new ParsePosition(0);
        TemporalAccessor temporal = this.parser.parse((CharSequence)text.trim(), pos);
        if (pos.getIndex() != text.length()) {
            throw new DateTimeParseException(String.format("Could not parse temporal at index %d: %s", pos.getIndex(), text), text, pos.getIndex());
        }
        return temporal;
    }

    @Override
    public String format(TemporalAccessor temporal) {
        if (temporal == null) {
            return null;
        }
        return this.formatter.format(temporal);
    }
}

