/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.config.model;

import com.datastax.oss.dsbulk.config.model.SettingsGroup;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

class ContainerSettingsGroup
implements SettingsGroup {
    private final Set<String> settings;
    private final String prefix;
    private final boolean includeDescendants;

    ContainerSettingsGroup(String path, boolean includeDescendants, Comparator<String> comparator) {
        this.prefix = path + ".";
        this.includeDescendants = includeDescendants;
        this.settings = new TreeSet<String>(comparator);
    }

    @Override
    public boolean addSetting(String settingName) {
        if (settingName.startsWith(this.prefix) && (this.includeDescendants || settingName.lastIndexOf(".") + 1 == this.prefix.length())) {
            this.settings.add(settingName);
        }
        return false;
    }

    @Override
    public Set<String> getSettings() {
        return this.settings;
    }
}

