/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.config.model;

import com.datastax.oss.dsbulk.config.ConfigUtils;
import com.datastax.oss.dsbulk.config.model.ContainerSettingsGroup;
import com.datastax.oss.dsbulk.config.model.FixedSettingsGroup;
import com.datastax.oss.dsbulk.config.model.OrderedSettingsGroup;
import com.datastax.oss.dsbulk.config.model.SettingsComparator;
import com.datastax.oss.dsbulk.config.model.SettingsGroup;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiConsumer;

public class SettingsGroupFactory {
    private static final SettingsComparator POPULAR_SECTIONS_FIRST = new SettingsComparator("Common", "dsbulk.connector", "dsbulk.schema");
    public static final Comparator<Map.Entry<String, ConfigValue>> ORIGIN_COMPARATOR = (e1, e2) -> {
        if (((String)e1.getKey()).equals(e2.getKey())) {
            return 0;
        }
        ConfigOrigin o1 = ((ConfigValue)e1.getValue()).origin();
        ConfigOrigin o2 = ((ConfigValue)e2.getValue()).origin();
        int positionComparison = Integer.compare(o1.lineNumber(), o2.lineNumber());
        if (positionComparison != 0) {
            return positionComparison;
        }
        return ((String)e1.getKey()).compareTo((String)e2.getKey());
    };

    public static Map<String, SettingsGroup> createDSBulkConfigurationGroups(boolean includeDriver) {
        Config referenceConfig = ConfigUtils.standaloneDSBulkReference();
        List<String> commonSettings = SettingsGroupFactory.parseCommonSettings(referenceConfig);
        List<String> preferredSettings = SettingsGroupFactory.parsePreferredSettings(referenceConfig, commonSettings);
        SettingsComparator comparator = new SettingsComparator(preferredSettings);
        TreeMap<String, SettingsGroup> groups = new TreeMap<String, SettingsGroup>(POPULAR_SECTIONS_FIRST);
        groups.put("Common", new FixedSettingsGroup(commonSettings));
        ConfigObject dsbulkRoot = referenceConfig.getConfig("dsbulk").root();
        SettingsGroupFactory.addDsbulkSections(groups, dsbulkRoot, comparator);
        SettingsGroupFactory.populateDsbulkSettings(groups, dsbulkRoot, "dsbulk");
        if (includeDriver) {
            Config driverConfig = ConfigUtils.standaloneDriverReference().getConfig("datastax-java-driver");
            OrderedSettingsGroup driverGroup = new OrderedSettingsGroup();
            SettingsGroupFactory.populateDriverGroup(driverGroup, driverConfig.root(), "datastax-java-driver");
            groups.put("datastax-java-driver", driverGroup);
        }
        return groups;
    }

    @NonNull
    private static List<String> parseCommonSettings(@NonNull Config referenceConfig) {
        ArrayList<String> commonSettings = new ArrayList<String>();
        commonSettings.add("dsbulk.connector.name");
        SettingsGroupFactory.visitConnectors(referenceConfig, (connectorName, connectorConfig) -> {
            if (connectorConfig.hasPath("metaSettings.docHints.commonSettings")) {
                connectorConfig.getStringList("metaSettings.docHints.commonSettings").stream().map(s -> String.format("dsbulk.connector.%s.%s", connectorName, s)).forEach(commonSettings::add);
            }
        });
        commonSettings.addAll(referenceConfig.getStringList("dsbulk.metaSettings.docHints.commonSettings"));
        return commonSettings;
    }

    @NonNull
    private static List<String> parsePreferredSettings(@NonNull Config referenceConfig, @NonNull List<String> commonSettings) {
        ArrayList<String> preferredSettings = new ArrayList<String>(commonSettings);
        preferredSettings.addAll(referenceConfig.getStringList("dsbulk.metaSettings.docHints.preferredSettings"));
        SettingsGroupFactory.visitConnectors(referenceConfig, (connectorName, connectorConfig) -> {
            if (connectorConfig.hasPath("metaSettings.docHints.preferredSettings")) {
                connectorConfig.getStringList("metaSettings.docHints.preferredSettings").stream().map(s -> String.format("dsbulk.connector.%s.%s", connectorName, s)).forEach(preferredSettings::add);
            }
        });
        return preferredSettings;
    }

    private static void addDsbulkSections(@NonNull Map<String, SettingsGroup> groups, @NonNull ConfigObject root, @NonNull Comparator<String> comparator) {
        block10: for (Map.Entry entry : root.entrySet()) {
            String key;
            switch (key = (String)entry.getKey()) {
                case "metaSettings": {
                    break;
                }
                case "driver": {
                    break;
                }
                case "connector": {
                    groups.put("dsbulk." + key, new ContainerSettingsGroup("dsbulk." + key, false, comparator));
                    for (Map.Entry child : ((ConfigObject)entry.getValue()).entrySet()) {
                        if (ConfigUtils.isLeaf((ConfigValue)child.getValue())) continue;
                        groups.put("dsbulk." + key + "." + (String)child.getKey(), new ContainerSettingsGroup("dsbulk." + key + "." + (String)child.getKey(), true, comparator));
                    }
                    continue block10;
                }
                default: {
                    groups.put("dsbulk." + key, new ContainerSettingsGroup("dsbulk." + key, true, comparator));
                }
            }
        }
    }

    private static void populateDsbulkSettings(@NonNull Map<String, SettingsGroup> groups, @NonNull ConfigObject root, @NonNull String rootPath) {
        for (Map.Entry entry : root.entrySet()) {
            String fullKey;
            String key = (String)entry.getKey();
            if (key.equals("metaSettings")) continue;
            ConfigValue value = (ConfigValue)entry.getValue();
            String string = fullKey = rootPath.isEmpty() ? key : rootPath + '.' + key;
            if (ConfigUtils.isLeaf(value)) {
                for (SettingsGroup group : groups.values()) {
                    if (group.addSetting(fullKey)) break;
                }
                continue;
            }
            SettingsGroupFactory.populateDsbulkSettings(groups, (ConfigObject)value, fullKey);
        }
    }

    private static void populateDriverGroup(@NonNull SettingsGroup driverGroup, @NonNull ConfigObject root, @NonNull String path) {
        TreeSet<Map.Entry<String, ConfigValue>> entries = new TreeSet<Map.Entry<String, ConfigValue>>(ORIGIN_COMPARATOR);
        entries.addAll(root.entrySet());
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            String fullKey = path.isEmpty() ? key : path + '.' + key;
            ConfigValue value = ConfigUtils.getNullSafeValue(root.toConfig(), key);
            if (ConfigUtils.isLeaf(value)) {
                driverGroup.addSetting(fullKey);
                continue;
            }
            SettingsGroupFactory.populateDriverGroup(driverGroup, (ConfigObject)value, fullKey);
        }
    }

    private static void visitConnectors(Config referenceConfig, BiConsumer<String, Config> action) {
        TreeSet<String> connectorChildren = new TreeSet<String>();
        for (Map.Entry nonLeafEntry : referenceConfig.getObject("dsbulk.connector").entrySet()) {
            connectorChildren.add((String)nonLeafEntry.getKey());
        }
        for (String connectorName : connectorChildren) {
            ConfigValue child = ConfigUtils.getNullSafeValue(referenceConfig, "dsbulk.connector." + connectorName);
            if (child.valueType() != ConfigValueType.OBJECT) continue;
            Config connectorConfig = ((ConfigObject)child).toConfig();
            action.accept(connectorName, connectorConfig);
        }
    }
}

