/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network;

import dorkbox.network.Client;
import dorkbox.network.pipeline.discovery.BroadcastResponse;
import dorkbox.network.pipeline.discovery.ClientDiscoverHostHandler;
import dorkbox.network.pipeline.discovery.ClientDiscoverHostInitializer;
import dorkbox.util.OS;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.oio.OioDatagramChannel;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Broadcast {
    private static final Logger logger = LoggerFactory.getLogger((String)Client.class.getSimpleName());

    public static String getVersion() {
        return "2.9";
    }

    public static BroadcastResponse discoverHost(int udpPort, int discoverTimeoutMillis) {
        BroadcastResponse discoverHost = Broadcast.discoverHostAddress(udpPort, discoverTimeoutMillis);
        if (discoverHost != null) {
            return discoverHost;
        }
        return null;
    }

    public static BroadcastResponse discoverHostAddress(int udpPort, int discoverTimeoutMillis) {
        List<BroadcastResponse> servers = Broadcast.discoverHost0(udpPort, discoverTimeoutMillis, false);
        if (servers.isEmpty()) {
            return null;
        }
        return servers.get(0);
    }

    public static List<BroadcastResponse> discoverHosts(int udpPort, int discoverTimeoutMillis) {
        return Broadcast.discoverHost0(udpPort, discoverTimeoutMillis, true);
    }

    private static List<BroadcastResponse> discoverHost0(int udpPort, int discoverTimeoutMillis, boolean fetchAllServers) {
        Enumeration<NetworkInterface> networkInterfaces;
        ByteBuf buffer = Unpooled.buffer((int)1);
        buffer.writeByte(42);
        ArrayList<BroadcastResponse> servers = new ArrayList<BroadcastResponse>();
        Logger logger2 = logger;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            logger2.error("Host discovery failed.", (Throwable)e);
            return new ArrayList<BroadcastResponse>(0);
        }
        block8: for (NetworkInterface networkInterface : Collections.list(networkInterfaces)) {
            for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                InetAddress address = interfaceAddress.getAddress();
                InetAddress broadcast = interfaceAddress.getBroadcast();
                if (address instanceof Inet6Address) {
                    if (!logger2.isInfoEnabled()) continue;
                    logger2.info("Not using IPv6 address: {}", (Object)address);
                    continue;
                }
                try {
                    ChannelFuture future;
                    Class<OioDatagramChannel> channelClass;
                    OioEventLoopGroup group;
                    if (logger2.isInfoEnabled()) {
                        logger2.info("Searching for host on [{}:{}]", (Object)address.getHostAddress(), (Object)udpPort);
                    }
                    if (OS.isAndroid()) {
                        group = new OioEventLoopGroup(1);
                        channelClass = OioDatagramChannel.class;
                    } else {
                        group = new NioEventLoopGroup(1);
                        channelClass = NioDatagramChannel.class;
                    }
                    Bootstrap udpBootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(channelClass)).option(ChannelOption.SO_BROADCAST, (Object)true)).handler((ChannelHandler)new ClientDiscoverHostInitializer())).localAddress((SocketAddress)new InetSocketAddress(address, 0));
                    try {
                        future = udpBootstrap.bind();
                        future.await();
                    }
                    catch (InterruptedException e) {
                        logger2.error("Could not bind to random UDP address on the server.", e.getCause());
                        throw new IllegalArgumentException();
                    }
                    if (!future.isSuccess()) {
                        logger2.error("Could not bind to random UDP address on the server.", future.cause());
                        throw new IllegalArgumentException();
                    }
                    Channel channel1 = future.channel();
                    if (broadcast != null) {
                        channel1.writeAndFlush((Object)new DatagramPacket(buffer, new InetSocketAddress(broadcast, udpPort)));
                        if (!channel1.closeFuture().awaitUninterruptibly((long)discoverTimeoutMillis)) {
                            if (logger2.isInfoEnabled()) {
                                logger2.info("Host discovery timed out.");
                            }
                        } else {
                            BroadcastResponse broadcastResponse = (BroadcastResponse)channel1.attr(ClientDiscoverHostHandler.STATE).get();
                            servers.add(broadcastResponse);
                        }
                        if (!fetchAllServers && !servers.isEmpty()) {
                            channel1.close().await();
                            group.shutdownGracefully().await();
                            break block8;
                        }
                    }
                    byte[] ip = address.getAddress();
                    for (int octect = 3; octect >= 0; --octect) {
                        ip[octect] = -1;
                        try {
                            InetAddress byAddress = InetAddress.getByAddress(ip);
                            channel1.writeAndFlush((Object)new DatagramPacket(buffer, new InetSocketAddress(byAddress, udpPort)));
                            if (!channel1.closeFuture().awaitUninterruptibly((long)discoverTimeoutMillis)) {
                                if (!logger2.isInfoEnabled()) continue;
                                logger2.info("Host discovery timed out.");
                                continue;
                            }
                            BroadcastResponse broadcastResponse = (BroadcastResponse)channel1.attr(ClientDiscoverHostHandler.STATE).get();
                            servers.add(broadcastResponse);
                            if (fetchAllServers) continue;
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    channel1.close().sync();
                    group.shutdownGracefully(0L, (long)discoverTimeoutMillis, TimeUnit.MILLISECONDS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (fetchAllServers || servers.isEmpty()) continue;
                break block8;
            }
        }
        if (logger2.isInfoEnabled() && !servers.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(256);
            if (fetchAllServers) {
                stringBuilder.append("Discovered servers: (").append(servers.size()).append(")");
                for (BroadcastResponse server : servers) {
                    stringBuilder.append("/n").append(server.remoteAddress).append(":");
                    if (server.tcpPort > 0) {
                        stringBuilder.append(server.tcpPort);
                        if (server.udpPort > 0) {
                            stringBuilder.append(":");
                        }
                    }
                    if (server.udpPort <= 0) continue;
                    stringBuilder.append(udpPort);
                }
                logger2.info(stringBuilder.toString());
            } else {
                BroadcastResponse broadcastResponse = (BroadcastResponse)servers.get(0);
                stringBuilder.append(broadcastResponse.remoteAddress).append(":");
                if (broadcastResponse.tcpPort > 0) {
                    stringBuilder.append(broadcastResponse.tcpPort);
                    if (broadcastResponse.udpPort > 0) {
                        stringBuilder.append(":");
                    }
                }
                if (broadcastResponse.udpPort > 0) {
                    stringBuilder.append(udpPort);
                }
                logger2.info("Discovered server [{}]", (Object)stringBuilder.toString());
            }
        }
        return servers;
    }

    private Broadcast() {
    }
}

