/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network;

import dorkbox.network.Configuration;
import dorkbox.network.NativeLibrary;
import dorkbox.network.connection.BootstrapWrapper;
import dorkbox.network.connection.Connection;
import dorkbox.network.connection.EndPoint;
import dorkbox.network.connection.EndPointClient;
import dorkbox.network.connection.idle.IdleBridge;
import dorkbox.network.connection.idle.IdleSender;
import dorkbox.network.connection.registration.local.RegistrationLocalHandlerClient;
import dorkbox.network.connection.registration.remote.RegistrationRemoteHandlerClientTCP;
import dorkbox.network.connection.registration.remote.RegistrationRemoteHandlerClientUDP;
import dorkbox.network.pipeline.ConnectionType;
import dorkbox.network.rmi.RemoteObjectCallback;
import dorkbox.util.OS;
import dorkbox.util.exceptions.SecurityException;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.socket.oio.OioDatagramChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class Client<C extends Connection>
extends EndPointClient
implements Connection {
    private final String localChannelName;
    private final String hostName;
    private Configuration config;

    public static String getVersion() {
        return "2.9";
    }

    public Client() throws SecurityException {
        this(Configuration.localOnly());
    }

    public Client(String host, int tcpPort, int udpPort, String localChannelName) throws SecurityException {
        this(new Configuration(host, tcpPort, udpPort, localChannelName));
    }

    public Client(Configuration config) throws SecurityException {
        super(config);
        boolean isLocalChannel;
        String threadName = Client.class.getSimpleName();
        this.config = config;
        boolean hostConfigured = (config.tcpPort > 0 || config.udpPort > 0) && config.host != null;
        boolean bl = isLocalChannel = config.localChannelName != null;
        if (isLocalChannel && hostConfigured) {
            String msg = threadName + " Local channel use and TCP/UDP use are MUTUALLY exclusive. Unable to determine what to do.";
            this.logger.error(msg);
            throw new IllegalArgumentException(msg);
        }
        this.localChannelName = config.localChannelName;
        this.hostName = config.host;
        if (config.localChannelName != null && config.tcpPort <= 0 && config.udpPort <= 0) {
            Bootstrap localBootstrap = new Bootstrap();
            this.bootstraps.add(new BootstrapWrapper("LOCAL", config.localChannelName, -1, localBootstrap));
            ((Bootstrap)((Bootstrap)localBootstrap.group(this.newEventLoop(ConnectionType.LOCAL, 1, threadName + "-JVM-BOSS"))).channel(LocalChannel.class)).remoteAddress((SocketAddress)new LocalAddress(config.localChannelName)).handler((ChannelHandler)new RegistrationLocalHandlerClient(threadName, this.registrationWrapper));
        } else {
            if (config.host == null) {
                throw new IllegalArgumentException("You must define what host you want to connect to.");
            }
            if (config.tcpPort <= 0 && config.udpPort <= 0) {
                throw new IllegalArgumentException("You must define what port you want to connect to.");
            }
            if (config.tcpPort > 0) {
                Bootstrap tcpBootstrap = new Bootstrap();
                this.bootstraps.add(new BootstrapWrapper("TCP", config.host, config.tcpPort, tcpBootstrap));
                if (OS.isAndroid()) {
                    tcpBootstrap.channel(OioSocketChannel.class);
                } else if (OS.isLinux() && NativeLibrary.isAvailable()) {
                    tcpBootstrap.channel(EpollSocketChannel.class);
                } else if (OS.isMacOsX() && NativeLibrary.isAvailable()) {
                    tcpBootstrap.channel(KQueueSocketChannel.class);
                } else {
                    tcpBootstrap.channel(NioSocketChannel.class);
                }
                ((Bootstrap)((Bootstrap)((Bootstrap)tcpBootstrap.group(this.newEventLoop(1, threadName + "-TCP-BOSS"))).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).remoteAddress(config.host, config.tcpPort).handler((ChannelHandler)new RegistrationRemoteHandlerClientTCP(threadName, this.registrationWrapper, this.newEventLoop(WORKER_THREAD_POOL_SIZE, threadName)));
                ((Bootstrap)tcpBootstrap.option(ChannelOption.TCP_NODELAY, (Object)(!OS.isAndroid() ? 1 : 0))).option(ChannelOption.SO_KEEPALIVE, (Object)true);
            }
            if (config.udpPort > 0) {
                Bootstrap udpBootstrap = new Bootstrap();
                this.bootstraps.add(new BootstrapWrapper("UDP", config.host, config.udpPort, udpBootstrap));
                if (OS.isAndroid()) {
                    udpBootstrap.channel(OioDatagramChannel.class);
                } else if (OS.isLinux() && NativeLibrary.isAvailable()) {
                    udpBootstrap.channel(EpollDatagramChannel.class);
                } else if (OS.isMacOsX() && NativeLibrary.isAvailable()) {
                    udpBootstrap.channel(KQueueDatagramChannel.class);
                } else {
                    udpBootstrap.channel(NioDatagramChannel.class);
                }
                ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)udpBootstrap.group(this.newEventLoop(1, threadName + "-UDP-BOSS"))).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(EndPoint.udpMaxSize))).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).localAddress((SocketAddress)new InetSocketAddress(0))).remoteAddress((SocketAddress)new InetSocketAddress(config.host, config.udpPort)).handler((ChannelHandler)new RegistrationRemoteHandlerClientUDP(threadName, this.registrationWrapper, this.newEventLoop(WORKER_THREAD_POOL_SIZE, threadName)));
                ((Bootstrap)udpBootstrap.option(ChannelOption.SO_BROADCAST, (Object)false)).option(ChannelOption.SO_SNDBUF, (Object)udpMaxSize);
            }
        }
    }

    public void reconnect() throws IOException {
        this.reconnect(this.connectionTimeout);
    }

    public void reconnect(int connectionTimeout) throws IOException {
        this.close();
        this.connect(connectionTimeout);
    }

    public void connect() throws IOException {
        this.connect(30000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(final int connectionTimeout) throws IOException {
        this.connectionTimeout = connectionTimeout;
        Object object = this.shutdownInProgress;
        synchronized (object) {
        }
        if (Client.isNettyThread()) {
            Client.runNewThread("Restart Thread", new Runnable(){

                @Override
                public void run() {
                    try {
                        Client.this.connect(connectionTimeout);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            return;
        }
        if (this.isShutdown()) {
            throw new IOException("Unable to connect when shutdown...");
        }
        if (this.localChannelName != null) {
            this.logger.info("Connecting to local server: {}", (Object)this.localChannelName);
        } else if (this.config.tcpPort > 0 && this.config.udpPort > 0) {
            this.logger.info("Connecting to TCP/UDP server [{}:{}]", new Object[]{this.hostName, this.config.tcpPort, this.config.udpPort});
        } else if (this.config.tcpPort > 0) {
            this.logger.info("Connecting to TCP server  [{}:{}]", (Object)this.hostName, (Object)this.config.tcpPort);
        } else {
            this.logger.info("Connecting to UDP server  [{}:{}]", (Object)this.hostName, (Object)this.config.udpPort);
        }
        this.startRegistration();
        if (this.config.tcpPort == 0 && this.config.udpPort > 0) {
            this.startUdpHeartbeat();
        }
    }

    @Override
    public boolean hasRemoteKeyChanged() {
        return this.connection.hasRemoteKeyChanged();
    }

    @Override
    public String getRemoteHost() {
        return this.connection.getRemoteHost();
    }

    @Override
    public boolean isLoopback() {
        return this.connection.isLoopback();
    }

    @Override
    public EndPoint getEndPoint() {
        return this;
    }

    @Override
    public int id() {
        return this.connection.id();
    }

    @Override
    public String idAsHex() {
        return this.connection.idAsHex();
    }

    @Override
    public boolean hasUDP() {
        return this.connection.hasUDP();
    }

    @Override
    public IdleBridge sendOnIdle(IdleSender<?, ?> sender) {
        return this.connection.sendOnIdle(sender);
    }

    @Override
    public IdleBridge sendOnIdle(Object message) {
        return this.connection.sendOnIdle(message);
    }

    @Override
    public void closeAsap() {
        this.connection.closeAsap();
    }

    @Override
    public <Iface> void createRemoteObject(Class<Iface> interfaceClass, RemoteObjectCallback<Iface> callback) {
        try {
            this.connection.createRemoteObject(interfaceClass, callback);
        }
        catch (NullPointerException e) {
            this.logger.error("Error creating remote object!", (Throwable)e);
        }
    }

    @Override
    public <Iface> void getRemoteObject(int objectId, RemoteObjectCallback<Iface> callback) {
        try {
            this.connection.getRemoteObject(objectId, callback);
        }
        catch (NullPointerException e) {
            this.logger.error("Error getting remote object!", (Throwable)e);
        }
    }

    public C getConnection() {
        return (C)this.connection;
    }

    @Override
    public void close() {
        this.closeConnection();
    }

    public boolean isConnected() {
        return this.isConnected.get();
    }
}

