/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network;

import dorkbox.network.NativeLibrary;
import dorkbox.network.connection.Shutdownable;
import dorkbox.network.dns.DnsQuestion;
import dorkbox.network.dns.Name;
import dorkbox.network.dns.records.ARecord;
import dorkbox.network.dns.serverHandlers.DnsServerHandler;
import dorkbox.util.NamedThreadFactory;
import dorkbox.util.OS;
import dorkbox.util.Property;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.oio.OioDatagramChannel;
import io.netty.channel.socket.oio.OioServerSocketChannel;
import io.netty.util.NetUtil;
import java.util.ArrayList;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;

public class DnsServer
extends Shutdownable {
    @Property
    public static int backlogConnectionCount = 50;
    private final ServerBootstrap tcpBootstrap;
    private final Bootstrap udpBootstrap;
    private final int tcpPort;
    private final int udpPort;
    private final String hostName;
    private final DnsServerHandler dnsServerHandler;

    public static void main(String[] args) {
        DnsServer server = new DnsServer("localhost", 2053);
        server.aRecord("google.com", 1, 10, "127.0.0.1");
        server.bind();
    }

    public DnsServer(String host, int port) {
        super(DnsServer.class);
        OioEventLoopGroup work;
        OioEventLoopGroup boss;
        this.tcpPort = port;
        this.udpPort = port;
        this.hostName = host == null ? "0.0.0.0" : host;
        this.dnsServerHandler = new DnsServerHandler(this.logger);
        String threadName = DnsServer.class.getSimpleName();
        if (OS.isAndroid()) {
            boss = new OioEventLoopGroup(1, (ThreadFactory)new NamedThreadFactory(threadName + "-boss", this.threadGroup));
            work = new OioEventLoopGroup(WORKER_THREAD_POOL_SIZE, (ThreadFactory)new NamedThreadFactory(threadName, this.threadGroup));
        } else if (OS.isLinux() && NativeLibrary.isAvailable()) {
            boss = new EpollEventLoopGroup(1, (ThreadFactory)new NamedThreadFactory(threadName + "-boss", this.threadGroup));
            work = new EpollEventLoopGroup(WORKER_THREAD_POOL_SIZE, (ThreadFactory)new NamedThreadFactory(threadName, this.threadGroup));
        } else if (OS.isMacOsX() && NativeLibrary.isAvailable()) {
            boss = new KQueueEventLoopGroup(1, (ThreadFactory)new NamedThreadFactory(threadName + "-boss", this.threadGroup));
            work = new KQueueEventLoopGroup(WORKER_THREAD_POOL_SIZE, (ThreadFactory)new NamedThreadFactory(threadName, this.threadGroup));
        } else {
            boss = new NioEventLoopGroup(1, (ThreadFactory)new NamedThreadFactory(threadName + "-boss", this.threadGroup));
            work = new NioEventLoopGroup(WORKER_THREAD_POOL_SIZE, (ThreadFactory)new NamedThreadFactory(threadName, this.threadGroup));
        }
        this.manageForShutdown((EventLoopGroup)boss);
        this.manageForShutdown((EventLoopGroup)work);
        this.tcpBootstrap = new ServerBootstrap();
        this.udpBootstrap = new Bootstrap();
        if (OS.isAndroid()) {
            this.tcpBootstrap.channel(OioServerSocketChannel.class);
        } else if (OS.isLinux() && NativeLibrary.isAvailable()) {
            this.tcpBootstrap.channel(EpollServerSocketChannel.class);
        } else if (OS.isMacOsX() && NativeLibrary.isAvailable()) {
            this.tcpBootstrap.channel(KQueueServerSocketChannel.class);
        } else {
            this.tcpBootstrap.channel(NioServerSocketChannel.class);
        }
        ((ServerBootstrap)((ServerBootstrap)this.tcpBootstrap.group((EventLoopGroup)boss, (EventLoopGroup)work).option(ChannelOption.SO_BACKLOG, (Object)backlogConnectionCount)).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).childHandler((ChannelHandler)this.dnsServerHandler);
        if (this.hostName.equals("0.0.0.0")) {
            this.tcpBootstrap.localAddress(this.tcpPort);
        } else {
            this.tcpBootstrap.localAddress(this.hostName, this.tcpPort);
        }
        ((ServerBootstrap)this.tcpBootstrap.option(ChannelOption.TCP_NODELAY, (Object)(!OS.isAndroid() ? 1 : 0))).childOption(ChannelOption.TCP_NODELAY, (Object)(!OS.isAndroid() ? 1 : 0));
        if (OS.isAndroid()) {
            this.udpBootstrap.channel(OioDatagramChannel.class);
        } else if (OS.isLinux() && NativeLibrary.isAvailable()) {
            this.udpBootstrap.channel(EpollDatagramChannel.class);
        } else if (OS.isMacOsX() && NativeLibrary.isAvailable()) {
            this.udpBootstrap.channel(KQueueDatagramChannel.class);
        } else {
            this.udpBootstrap.channel(NioDatagramChannel.class);
        }
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.udpBootstrap.group((EventLoopGroup)work)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).localAddress(this.udpPort)).handler((ChannelHandler)this.dnsServerHandler);
    }

    @Override
    protected void stopExtraActions() {
        this.dnsServerHandler.stop();
    }

    public void bind() {
        this.bind(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(boolean blockUntilTerminate) {
        ChannelFuture future;
        Object object = this.shutdownInProgress;
        synchronized (object) {
        }
        Logger logger2 = this.logger;
        try {
            future = this.udpBootstrap.bind();
            future.await();
        }
        catch (Exception e) {
            String errorMessage = this.stopWithErrorMessage(logger2, "Could not bind to address " + this.hostName + " UDP port " + this.udpPort + " on the server.", e);
            throw new IllegalArgumentException(errorMessage);
        }
        if (!future.isSuccess()) {
            String errorMessage = this.stopWithErrorMessage(logger2, "Could not bind to address " + this.hostName + " UDP port " + this.udpPort + " on the server.", future.cause());
            throw new IllegalArgumentException(errorMessage);
        }
        this.manageForShutdown(future);
        if (blockUntilTerminate) {
            this.waitForShutdown();
        }
    }

    public void aRecord(String domainName, int dClass, int ttl, String ... ipAddresses) {
        Name name = DnsQuestion.createName(domainName, 1);
        int length = ipAddresses.length;
        ArrayList<ARecord> records = new ArrayList<ARecord>(length);
        for (int i = 0; i < length; ++i) {
            byte[] address = NetUtil.createByteArrayFromIpAddressString((String)ipAddresses[i]);
            records.add(new ARecord(name, dClass, (long)ttl, address));
        }
        this.dnsServerHandler.addARecord(name, records);
    }
}

