/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network;

import dorkbox.network.connection.EndPoint;
import dorkbox.util.NativeLoader;
import dorkbox.util.OS;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.kqueue.KQueue;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import java.io.File;
import java.lang.reflect.Field;

public class NativeLibrary {
    public static boolean isAvailable() {
        if (!EndPoint.enableNativeLibrary) {
            return false;
        }
        if (OS.isLinux()) {
            return Epoll.isAvailable();
        }
        if (OS.isMacOsX()) {
            return KQueue.isAvailable();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        if (EndPoint.enableNativeLibrary && (OS.isLinux() || OS.isMacOsX())) {
            File outputDirectory;
            String originalLibraryPath = SystemPropertyUtil.get((String)"java.library.path");
            String workdir = SystemPropertyUtil.get((String)"io.netty.native.workdir");
            if (workdir != null) {
                File f = new File(workdir);
                if (!f.isDirectory()) {
                    f.mkdirs();
                }
                try {
                    f = f.getAbsoluteFile();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                outputDirectory = f;
            } else {
                outputDirectory = PlatformDependent.tmpdir();
            }
            try {
                System.setProperty("java.library.path", originalLibraryPath + File.pathSeparator + outputDirectory.getAbsolutePath());
                Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
                fieldSysPath.setAccessible(true);
                fieldSysPath.set(null, null);
            }
            catch (Exception fieldSysPath) {
                // empty catch block
            }
            String staticLibName = OS.isLinux() ? "netty_transport_native_epoll" : "netty_transport_native_kqueue";
            staticLibName = "lib" + staticLibName + '_' + PlatformDependent.normalizedArch();
            String jarLibName = "META-INF/native/" + staticLibName;
            jarLibName = OS.isLinux() ? jarLibName + ".so" : jarLibName + ".jnilib";
            try {
                NativeLoader.extractLibrary(jarLibName, outputDirectory.getAbsolutePath(), staticLibName, null);
                if (OS.isLinux()) {
                    Epoll.isAvailable();
                } else if (OS.isMacOsX()) {
                    KQueue.isAvailable();
                }
            }
            catch (Exception fieldSysPath) {
            }
            finally {
                System.setProperty("java.library.path", originalLibraryPath);
                try {
                    Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
                    fieldSysPath.setAccessible(true);
                    fieldSysPath.set(null, null);
                }
                catch (Exception fieldSysPath) {}
            }
        }
    }
}

