/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network;

import dorkbox.network.Configuration;
import dorkbox.network.NativeLibrary;
import dorkbox.network.connection.Connection;
import dorkbox.network.connection.EndPoint;
import dorkbox.network.connection.EndPointServer;
import dorkbox.network.connection.registration.local.RegistrationLocalHandlerServer;
import dorkbox.network.connection.registration.remote.RegistrationRemoteHandlerServerTCP;
import dorkbox.network.connection.registration.remote.RegistrationRemoteHandlerServerUDP;
import dorkbox.network.pipeline.ConnectionType;
import dorkbox.util.OS;
import dorkbox.util.Property;
import dorkbox.util.exceptions.SecurityException;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.bootstrap.SessionBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.oio.OioDatagramChannel;
import io.netty.channel.socket.oio.OioServerSocketChannel;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;

public class Server<C extends Connection>
extends EndPointServer {
    @Property
    public static int backlogConnectionCount = 50;
    private final ServerBootstrap localBootstrap;
    private final ServerBootstrap tcpBootstrap;
    private final SessionBootstrap udpBootstrap;
    private final int tcpPort;
    private final int udpPort;
    private final String localChannelName;
    private final String hostName;
    private volatile boolean isRunning = false;

    public static String getVersion() {
        return "2.9";
    }

    public Server() throws SecurityException {
        this(Configuration.localOnly());
    }

    public Server(Configuration config) throws SecurityException {
        super(config);
        this.tcpPort = config.tcpPort;
        this.udpPort = config.udpPort;
        this.localChannelName = config.localChannelName;
        if (config.host == null) {
            config.host = this.hostName = "0.0.0.0";
        } else {
            this.hostName = config.host;
        }
        this.localBootstrap = this.localChannelName != null ? new ServerBootstrap() : null;
        this.tcpBootstrap = this.tcpPort > 0 ? new ServerBootstrap() : null;
        this.udpBootstrap = this.udpPort > 0 ? new SessionBootstrap(this.tcpPort, this.udpPort) : null;
        String threadName = Server.class.getSimpleName();
        if (this.localBootstrap != null) {
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.localBootstrap.group(this.newEventLoop(ConnectionType.LOCAL, 1, threadName + "-JVM-BOSS"), this.newEventLoop(ConnectionType.LOCAL, 1, threadName)).channel(LocalServerChannel.class)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).localAddress((SocketAddress)new LocalAddress(this.localChannelName))).childHandler((ChannelHandler)new RegistrationLocalHandlerServer(threadName, this.registrationWrapper));
        }
        if (this.tcpBootstrap == null && this.udpBootstrap == null) {
            return;
        }
        if (this.tcpBootstrap != null) {
            if (OS.isAndroid()) {
                this.tcpBootstrap.channel(OioServerSocketChannel.class);
            } else if (OS.isLinux() && NativeLibrary.isAvailable()) {
                this.tcpBootstrap.channel(EpollServerSocketChannel.class);
            } else if (OS.isMacOsX() && NativeLibrary.isAvailable()) {
                this.tcpBootstrap.channel(KQueueServerSocketChannel.class);
            } else {
                this.tcpBootstrap.channel(NioServerSocketChannel.class);
            }
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.tcpBootstrap.group(this.newEventLoop(1, threadName + "-TCP-BOSS"), this.newEventLoop(1, threadName + "-TCP-HAND")).option(ChannelOption.SO_BACKLOG, (Object)backlogConnectionCount)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new RegistrationRemoteHandlerServerTCP(threadName, this.registrationWrapper, this.newEventLoop(WORKER_THREAD_POOL_SIZE, threadName)));
            if (this.hostName.equals("0.0.0.0")) {
                this.tcpBootstrap.localAddress(this.tcpPort);
            } else {
                this.tcpBootstrap.localAddress(this.hostName, this.tcpPort);
            }
            ((ServerBootstrap)this.tcpBootstrap.option(ChannelOption.TCP_NODELAY, (Object)(!OS.isAndroid() ? 1 : 0))).childOption(ChannelOption.TCP_NODELAY, (Object)(!OS.isAndroid() ? 1 : 0));
        }
        if (this.udpBootstrap != null) {
            if (OS.isAndroid()) {
                this.udpBootstrap.channel(OioDatagramChannel.class);
            } else if (OS.isLinux() && NativeLibrary.isAvailable()) {
                this.udpBootstrap.channel(EpollDatagramChannel.class);
            } else if (OS.isMacOsX() && NativeLibrary.isAvailable()) {
                this.udpBootstrap.channel(KQueueDatagramChannel.class);
            } else {
                this.udpBootstrap.channel(NioDatagramChannel.class);
            }
            FixedRecvByteBufAllocator recvByteBufAllocator = new FixedRecvByteBufAllocator(EndPoint.udpMaxSize);
            ((SessionBootstrap)((SessionBootstrap)((SessionBootstrap)((SessionBootstrap)this.udpBootstrap.group(this.newEventLoop(1, threadName + "-UDP-BOSS"), this.newEventLoop(1, threadName + "-UDP-HAND")).option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT)).option(ChannelOption.RCVBUF_ALLOCATOR, recvByteBufAllocator)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, new WriteBufferWaterMark(8192, 32768))).localAddress(this.udpPort)).childHandler((ChannelHandler)new RegistrationRemoteHandlerServerUDP(threadName, this.registrationWrapper, this.newEventLoop(WORKER_THREAD_POOL_SIZE, threadName)));
            ((SessionBootstrap)this.udpBootstrap.option(ChannelOption.SO_BROADCAST, false)).option(ChannelOption.SO_SNDBUF, udpMaxSize);
        }
    }

    public void bind() {
        this.bind(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(boolean blockUntilTerminate) {
        ChannelFuture future;
        Object object = this.shutdownInProgress;
        synchronized (object) {
        }
        if (this.localBootstrap != null) {
            try {
                future = this.localBootstrap.bind();
                future.await();
            }
            catch (InterruptedException e) {
                throw new IllegalArgumentException("Could not bind to LOCAL address '" + this.localChannelName + "' on the server.", e);
            }
            if (!future.isSuccess()) {
                throw new IllegalArgumentException("Could not bind to LOCAL address '" + this.localChannelName + "' on the server.", future.cause());
            }
            this.logger.info("Listening on LOCAL address: [{}]", (Object)this.localChannelName);
            this.manageForShutdown(future);
        }
        if (this.tcpBootstrap != null) {
            try {
                future = this.tcpBootstrap.bind();
                future.await();
            }
            catch (Exception e) {
                this.stop();
                throw new IllegalArgumentException("Could not bind to address " + this.hostName + " TCP port " + this.tcpPort + " on the server.", e);
            }
            if (!future.isSuccess()) {
                this.stop();
                throw new IllegalArgumentException("Could not bind to address " + this.hostName + " TCP port " + this.tcpPort + " on the server.", future.cause());
            }
            this.logger.info("TCP server listen address [{}:{}]", (Object)this.hostName, (Object)this.tcpPort);
            this.manageForShutdown(future);
        }
        if (this.udpBootstrap != null) {
            try {
                future = this.udpBootstrap.bind();
                future.await();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not bind to address " + this.hostName + " UDP port " + this.udpPort + " on the server.", e);
            }
            if (!future.isSuccess()) {
                throw new IllegalArgumentException("Could not bind to address " + this.hostName + " UDP port " + this.udpPort + " on the server.", future.cause());
            }
            this.logger.info("UDP server listen address [{}:{}]", (Object)this.hostName, (Object)this.udpPort);
            this.manageForShutdown(future);
        }
        this.isRunning = true;
        if (blockUntilTerminate) {
            this.waitForShutdown();
        }
    }

    @Override
    protected void stopExtraActions() {
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public static boolean isRunning(Configuration config) {
        String host = config.host;
        if (host == null) {
            host = "0.0.0.0";
        }
        if (config.tcpPort == 0) {
            return false;
        }
        Socket sock = null;
        try {
            sock = new Socket(host, config.tcpPort);
            return sock.isConnected();
        }
        catch (Exception ignored) {
            if (sock != null) {
                try {
                    sock.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

