/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.network.connection;

import dorkbox.network.Client;
import dorkbox.network.connection.Connection;
import dorkbox.network.connection.ConnectionManager;
import dorkbox.network.connection.ConnectionPoint;
import dorkbox.network.connection.CryptoConnection;
import dorkbox.network.connection.EndPoint;
import dorkbox.network.connection.EndPointClient;
import dorkbox.network.connection.EndPointServer;
import dorkbox.network.connection.ISessionManager;
import dorkbox.network.connection.KryoExtra;
import dorkbox.network.connection.Listener;
import dorkbox.network.connection.Listeners;
import dorkbox.network.connection.Ping;
import dorkbox.network.connection.Shutdownable;
import dorkbox.network.connection.bridge.ConnectionBridge;
import dorkbox.network.connection.idle.IdleBridge;
import dorkbox.network.connection.idle.IdleSender;
import dorkbox.network.connection.idle.IdleSenderFactory;
import dorkbox.network.connection.ping.PingFuture;
import dorkbox.network.connection.ping.PingMessage;
import dorkbox.network.connection.wrapper.ChannelNetworkWrapper;
import dorkbox.network.connection.wrapper.ChannelNull;
import dorkbox.network.connection.wrapper.ChannelWrapper;
import dorkbox.network.rmi.InvokeMethod;
import dorkbox.network.rmi.InvokeMethodResult;
import dorkbox.network.rmi.RemoteObject;
import dorkbox.network.rmi.RemoteObjectCallback;
import dorkbox.network.rmi.Rmi;
import dorkbox.network.rmi.RmiBridge;
import dorkbox.network.rmi.RmiMessage;
import dorkbox.network.rmi.RmiObjectHandler;
import dorkbox.network.rmi.RmiProxyHandler;
import dorkbox.network.rmi.RmiRegistration;
import dorkbox.network.serialization.CryptoSerializationManager;
import dorkbox.util.collections.LockFreeHashMap;
import dorkbox.util.collections.LockFreeIntMap;
import dorkbox.util.generics.ClassHelper;
import io.netty.bootstrap.DatagramSessionChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.socket.oio.OioDatagramChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.slf4j.Logger;

@ChannelHandler.Sharable
public class ConnectionImpl
extends ChannelInboundHandlerAdapter
implements CryptoConnection,
Connection,
Listeners,
ConnectionBridge {
    private final Logger logger;
    private final AtomicBoolean needsLock = new AtomicBoolean(false);
    private final AtomicBoolean writeSignalNeeded = new AtomicBoolean(false);
    private final Object writeLock = new Object();
    private final AtomicBoolean closeInProgress = new AtomicBoolean(false);
    private final AtomicBoolean channelIsClosed = new AtomicBoolean(false);
    private final Object messageInProgressLock = new Object();
    private final AtomicBoolean messageInProgress = new AtomicBoolean(false);
    private ISessionManager sessionManager;
    private ChannelWrapper channelWrapper;
    private volatile PingFuture pingFuture = null;
    private volatile ConnectionManager localListenerManager;
    private boolean remoteKeyChanged;
    private final EndPoint endPoint;
    private boolean closeAsap = false;
    private final AtomicLong aes_gcm_iv = new AtomicLong(0L);
    private CountDownLatch closeLatch;
    private final RmiBridge rmiBridge;
    private final Map<Integer, RemoteObject> proxyIdCache;
    private final List<Listener.OnMessageReceived<Connection, InvokeMethodResult>> proxyListeners;
    private final LockFreeIntMap<RemoteObjectCallback> rmiRegistrationCallbacks;
    private volatile int rmiCallbackId = 0;

    public static boolean isTcpChannel(Class<? extends Channel> channelClass) {
        return channelClass == OioSocketChannel.class || channelClass == NioSocketChannel.class || channelClass == KQueueSocketChannel.class || channelClass == EpollSocketChannel.class;
    }

    public static boolean isUdpChannel(Class<? extends Channel> channelClass) {
        return channelClass == OioDatagramChannel.class || channelClass == NioDatagramChannel.class || channelClass == KQueueDatagramChannel.class || channelClass == EpollDatagramChannel.class || channelClass == DatagramSessionChannel.class;
    }

    public static boolean isLocalChannel(Class<? extends Channel> channelClass) {
        return channelClass == LocalChannel.class;
    }

    public ConnectionImpl(Logger logger, EndPoint endPoint, RmiBridge rmiBridge) {
        this.logger = logger;
        this.endPoint = endPoint;
        this.rmiBridge = rmiBridge;
        if (endPoint != null && endPoint.globalRmiBridge != null) {
            this.proxyIdCache = new LockFreeHashMap<Integer, RemoteObject>();
            this.proxyListeners = new CopyOnWriteArrayList<Listener.OnMessageReceived<Connection, InvokeMethodResult>>();
            this.rmiRegistrationCallbacks = new LockFreeIntMap();
        } else {
            this.proxyIdCache = null;
            this.proxyListeners = null;
            this.rmiRegistrationCallbacks = null;
        }
    }

    final void init(ChannelWrapper channelWrapper, ISessionManager sessionManager) {
        this.sessionManager = sessionManager;
        this.channelWrapper = channelWrapper;
        if (this.channelWrapper instanceof ChannelNetworkWrapper) {
            this.remoteKeyChanged = ((ChannelNetworkWrapper)this.channelWrapper).remoteKeyChanged();
            int count = 0;
            if (channelWrapper.tcp() != null) {
                ++count;
            }
            if (channelWrapper.udp() != null) {
                ++count;
            }
            this.closeLatch = new CountDownLatch(count);
        } else {
            this.remoteKeyChanged = false;
            this.closeLatch = new CountDownLatch(1);
        }
    }

    @Override
    public final ParametersWithIV getCryptoParameters() {
        return this.channelWrapper.cryptoParameters();
    }

    @Override
    public final long getNextGcmSequence() {
        return this.aes_gcm_iv.getAndIncrement();
    }

    @Override
    public boolean hasRemoteKeyChanged() {
        return this.remoteKeyChanged;
    }

    @Override
    public String getRemoteHost() {
        return this.channelWrapper.getRemoteHost();
    }

    @Override
    public boolean isLoopback() {
        return this.channelWrapper.isLoopback();
    }

    @Override
    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    @Override
    public int id() {
        return this.channelWrapper.id();
    }

    @Override
    public String idAsHex() {
        return Integer.toHexString(this.id());
    }

    public final void updatePingResponse(PingMessage ping) {
        if (this.pingFuture != null) {
            this.pingFuture.setSuccess(this, ping);
        }
    }

    @Override
    public final Ping ping() {
        PingFuture pingFuture2 = this.pingFuture;
        if (pingFuture2 != null && !pingFuture2.isSuccess()) {
            pingFuture2.cancel();
        }
        Promise newPromise = this.channelWrapper.udp() != null ? this.channelWrapper.udp().newPromise() : this.channelWrapper.tcp().newPromise();
        this.pingFuture = new PingFuture(newPromise);
        PingMessage ping = new PingMessage();
        ping.id = this.pingFuture.getId();
        this.ping0(ping);
        return this.pingFuture;
    }

    public final void ping0(PingMessage ping) {
        if (this.channelWrapper.udp() != null) {
            this.UDP(ping).flush();
        } else if (this.channelWrapper.tcp() != null) {
            this.TCP(ping).flush();
        } else {
            this.self(ping);
        }
    }

    public final int getLastRoundTripTime() {
        PingFuture pingFuture2 = this.pingFuture;
        if (pingFuture2 != null) {
            return pingFuture2.getResponse();
        }
        return -1;
    }

    @Override
    public final boolean hasUDP() {
        return this.channelWrapper.udp() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelWritabilityChanged(ChannelHandlerContext context) throws Exception {
        super.channelWritabilityChanged(context);
        if (this.writeSignalNeeded.getAndSet(false)) {
            Object object = this.writeLock;
            synchronized (object) {
                this.needsLock.set(false);
                this.writeLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void controlBackPressure(ConnectionPoint c) {
        while (!this.closeInProgress.get() && !c.isWritable()) {
            this.needsLock.set(true);
            this.writeSignalNeeded.set(true);
            Object object = this.writeLock;
            synchronized (object) {
                if (this.needsLock.get()) {
                    try {
                        this.writeLock.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public final ConnectionBridge send() {
        return this;
    }

    @Override
    public final ConnectionPoint send(Object message) {
        if (this.channelWrapper.tcp() != null) {
            return this.TCP(message);
        }
        if (this.channelWrapper.udp() != null) {
            return this.UDP(message);
        }
        this.self(message);
        return ChannelNull.get();
    }

    @Override
    public final ConnectionPoint self(Object message) {
        this.logger.trace("Sending LOCAL {}", message);
        this.sessionManager.onMessage(this, message);
        return this.channelWrapper.tcp();
    }

    @Override
    public final ConnectionPoint TCP(Object message) {
        if (!this.closeInProgress.get()) {
            this.logger.trace("Sending TCP {}", message);
            ConnectionPoint tcp = this.channelWrapper.tcp();
            try {
                tcp.write(message);
            }
            catch (Exception e) {
                this.logger.error("Unable to write TCP object {}", message.getClass(), (Object)e);
            }
            return tcp;
        }
        this.logger.debug("writing TCP while closed: {}", message);
        return ChannelNull.get();
    }

    @Override
    public ConnectionPoint UDP(Object message) {
        if (!this.closeInProgress.get()) {
            this.logger.trace("Sending UDP {}", message);
            ConnectionPoint udp = this.channelWrapper.udp();
            try {
                udp.write(message);
            }
            catch (Exception e) {
                this.logger.error("Unable to write UDP object {}", message.getClass(), (Object)e);
            }
            return udp;
        }
        this.logger.debug("writing UDP while closed: {}", message);
        return ChannelNull.get();
    }

    final void flush() {
        this.channelWrapper.flush();
    }

    public final IdleBridge sendOnIdle(IdleSender sender) {
        return new IdleSenderFactory(this, sender);
    }

    @Override
    public final IdleBridge sendOnIdle(Object message) {
        return new IdleSenderFactory(this, message);
    }

    public void userEventTriggered(ChannelHandlerContext context, Object event) throws Exception {
        if (event instanceof IdleStateEvent && ((IdleStateEvent)event).state() == IdleState.ALL_IDLE) {
            this.sessionManager.onIdle(this);
        }
        super.userEventTriggered(context, event);
    }

    public void channelRead(ChannelHandlerContext context, Object message) throws Exception {
        this.channelRead(message);
        ReferenceCountUtil.release((Object)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void channelRead(Object object) {
        this.messageInProgress.set(true);
        this.sessionManager.onMessage(this, object);
        this.messageInProgress.set(false);
        if (this.closeInProgress.get()) {
            Object object2 = this.messageInProgressLock;
            synchronized (object2) {
                this.messageInProgressLock.notifyAll();
            }
        }
        if (this.closeAsap) {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(ChannelHandlerContext context) throws Exception {
        if (this.messageInProgress.get()) {
            Object object = this.messageInProgressLock;
            synchronized (object) {
                try {
                    this.messageInProgressLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        Channel channel = context.channel();
        Class<?> channelClass = channel.getClass();
        boolean isTCP = ConnectionImpl.isTcpChannel(channelClass);
        boolean isUDP = false;
        boolean isLocal = ConnectionImpl.isLocalChannel(channelClass);
        if (this.logger.isInfoEnabled()) {
            String type = isTCP ? "TCP" : ((isUDP = ConnectionImpl.isUdpChannel(channelClass)) ? "UDP" : (isLocal ? "LOCAL" : "UNKNOWN"));
            this.logger.info("Closed remote {} connection [{}]", (Object)type, (Object)EndPoint.getHostDetails(channel.remoteAddress()));
        }
        if (this.endPoint instanceof EndPointClient) {
            ((EndPointClient)this.endPoint).abortRegistration();
        }
        if (isLocal || isTCP || isUDP && this.channelWrapper.tcp() == null) {
            boolean doClose = this.channelIsClosed.compareAndSet(false, true);
            if (!this.closeInProgress.get()) {
                if (this.endPoint instanceof EndPointClient) {
                    ((Client)this.endPoint).close();
                } else {
                    this.close();
                }
            }
            if (doClose) {
                this.sessionManager.onDisconnected(this);
            }
        }
        this.closeLatch.countDown();
    }

    final void forceClose() {
        this.channelWrapper.close(this, this.sessionManager, true);
    }

    @Override
    public final void close() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close(final boolean keepListeners) {
        if (!this.closeInProgress.get() && this.messageInProgress.get() && Shutdownable.isNettyThread()) {
            Shutdownable.runNewThread("Close connection Thread", new Runnable(){

                @Override
                public void run() {
                    ConnectionImpl.this.close(keepListeners);
                }
            });
            return;
        }
        if (this.closeInProgress.compareAndSet(false, true)) {
            int idleTimeoutMs = this.endPoint.getIdleTimeout();
            if (idleTimeoutMs == 0) {
                idleTimeoutMs = 2000;
            }
            Object object = this.messageInProgressLock;
            synchronized (object) {
                while (this.messageInProgress.get()) {
                    try {
                        this.messageInProgressLock.wait(idleTimeoutMs);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.channelWrapper.flush();
            PingFuture pingFuture2 = this.pingFuture;
            if (pingFuture2 != null) {
                pingFuture2.cancel();
            }
            this.pingFuture = null;
            AtomicBoolean atomicBoolean = this.channelIsClosed;
            synchronized (atomicBoolean) {
                if (!this.channelIsClosed.get()) {
                    this.channelWrapper.close(this, this.sessionManager, false);
                    try {
                        this.closeLatch.await(idleTimeoutMs, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (!keepListeners) {
                this.removeAll();
            }
            if (this.proxyIdCache != null) {
                this.proxyIdCache.clear();
            }
            if (this.rmiRegistrationCallbacks != null) {
                this.rmiRegistrationCallbacks.clear();
            }
        }
    }

    @Override
    public final void closeAsap() {
        this.closeAsap = true;
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
        Channel channel = context.channel();
        if (!(cause instanceof IOException)) {
            this.logger.error("Unexpected exception while receiving data from {}", (Object)channel.remoteAddress(), (Object)cause);
            if (channel.isOpen()) {
                channel.close();
            }
        } else {
            this.logger.error("Unexpected exception while communicating with {}!", (Object)channel.remoteAddress(), (Object)cause);
        }
    }

    @Override
    public final Listeners listeners() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Listeners add(Listener listener) {
        if (this.endPoint instanceof EndPointServer) {
            ConnectionImpl connectionImpl = this;
            synchronized (connectionImpl) {
                if (this.localListenerManager == null) {
                    this.localListenerManager = ((EndPointServer)this.endPoint).addListenerManager(this);
                }
                this.localListenerManager.add(listener);
            }
        } else {
            this.endPoint.listeners().add(listener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Listeners remove(Listener listener) {
        if (this.endPoint instanceof EndPointServer) {
            ConnectionImpl connectionImpl = this;
            synchronized (connectionImpl) {
                if (this.localListenerManager != null) {
                    this.localListenerManager.remove(listener);
                    if (!this.localListenerManager.hasListeners()) {
                        ((EndPointServer)this.endPoint).removeListenerManager(this);
                    }
                }
            }
        } else {
            this.endPoint.listeners().remove(listener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Listeners removeAll() {
        if (this.proxyListeners != null) {
            this.proxyListeners.clear();
        }
        if (this.endPoint instanceof EndPointServer) {
            ConnectionImpl connectionImpl = this;
            synchronized (connectionImpl) {
                if (this.localListenerManager != null) {
                    this.localListenerManager.removeAll();
                    this.localListenerManager = null;
                    ((EndPointServer)this.endPoint).removeListenerManager(this);
                }
            }
        } else {
            this.endPoint.listeners().removeAll();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Listeners removeAll(Class<?> classType) {
        if (this.endPoint instanceof EndPointServer) {
            ConnectionImpl connectionImpl = this;
            synchronized (connectionImpl) {
                if (this.localListenerManager != null) {
                    this.localListenerManager.removeAll(classType);
                    if (!this.localListenerManager.hasListeners()) {
                        this.localListenerManager = null;
                        ((EndPointServer)this.endPoint).removeListenerManager(this);
                    }
                }
            }
        } else {
            this.endPoint.listeners().removeAll(classType);
        }
        return this;
    }

    public String toString() {
        return this.channelWrapper.toString();
    }

    public int hashCode() {
        return this.id();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionImpl other = (ConnectionImpl)obj;
        return !(this.channelWrapper == null ? other.channelWrapper != null : !this.channelWrapper.equals(other.channelWrapper));
    }

    @Override
    public final <Iface> void createRemoteObject(Class<Iface> interfaceClass, RemoteObjectCallback<Iface> callback) {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("Cannot create a proxy for RMI access. It must be an interface.");
        }
        int nextRmiCallbackId = this.rmiCallbackId++;
        this.rmiRegistrationCallbacks.put(nextRmiCallbackId, callback);
        RmiRegistration message = new RmiRegistration(interfaceClass, Integer.MAX_VALUE, nextRmiCallbackId);
        this.send(message).flush();
    }

    @Override
    public final <Iface> void getRemoteObject(int objectId, RemoteObjectCallback<Iface> callback) {
        if (objectId < 0) {
            throw new IllegalStateException("Object ID cannot be < 0");
        }
        if (objectId >= Integer.MAX_VALUE) {
            throw new IllegalStateException("Object ID cannot be >= 2147483647");
        }
        Class<?> iFaceClass = ClassHelper.getGenericParameterAsClassForSuperClass(RemoteObjectCallback.class, callback.getClass(), 0);
        int nextRmiCallbackId = this.rmiCallbackId++;
        this.rmiRegistrationCallbacks.put(nextRmiCallbackId, callback);
        RmiRegistration message = new RmiRegistration(iFaceClass, objectId, nextRmiCallbackId);
        this.send(message).flush();
    }

    boolean manageRmi(Object message) {
        if (message instanceof RmiMessage) {
            RmiObjectHandler rmiObjectHandler = this.channelWrapper.manageRmi();
            if (message instanceof InvokeMethod) {
                rmiObjectHandler.invoke(this, (InvokeMethod)message, this.rmiBridge.getListener());
            } else if (message instanceof InvokeMethodResult) {
                for (Listener.OnMessageReceived<Connection, InvokeMethodResult> proxyListener : this.proxyListeners) {
                    proxyListener.received(this, (InvokeMethodResult)message);
                }
            } else if (message instanceof RmiRegistration) {
                rmiObjectHandler.registration(this, (RmiRegistration)message);
            }
            return true;
        }
        return false;
    }

    Object fixupRmi(Object message) {
        RmiObjectHandler rmiObjectHandler = this.channelWrapper.manageRmi();
        return rmiObjectHandler.normalMessages(this, message);
    }

    public void removeRmiListeners(int objectID, Listener listener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RmiRegistration createNewRmiObject(Class<?> interfaceClass, Class<?> implementationClass, int callbackId) {
        CryptoSerializationManager manager = this.getEndPoint().serializationManager;
        KryoExtra kryo = null;
        Object object = null;
        int rmiId = 0;
        try {
            kryo = manager.takeKryo();
            object = kryo.newInstance(implementationClass);
            rmiId = this.rmiBridge.register(object);
            if (rmiId == Integer.MAX_VALUE) {
                object = null;
            } else {
                LinkedList<AbstractMap.SimpleEntry<Class<Object>, Object>> classesToCheck = new LinkedList<AbstractMap.SimpleEntry<Class<Object>, Object>>();
                classesToCheck.add(new AbstractMap.SimpleEntry(implementationClass, object));
                while (!classesToCheck.isEmpty()) {
                    Map.Entry remoteClassObject = (Map.Entry)classesToCheck.removeFirst();
                    for (Field field : ((Class)remoteClassObject.getKey()).getDeclaredFields()) {
                        if (field.getAnnotation(Rmi.class) == null) continue;
                        Class<?> type = field.getType();
                        if (!type.isInterface()) {
                            this.logger.error("Error checking RMI fields for: {}.{} -- It is not an interface!", remoteClassObject.getKey(), (Object)field.getName());
                            continue;
                        }
                        boolean prev = field.isAccessible();
                        field.setAccessible(true);
                        try {
                            Object o = field.get(remoteClassObject.getValue());
                            this.rmiBridge.register(o);
                            classesToCheck.add(new AbstractMap.SimpleEntry(type, o));
                        }
                        catch (IllegalAccessException e) {
                            this.logger.error("Error checking RMI fields for: {}.{}", new Object[]{remoteClassObject.getKey(), field.getName(), e});
                        }
                        finally {
                            field.setAccessible(prev);
                        }
                    }
                    Class superclass = ((Class)remoteClassObject.getKey()).getSuperclass();
                    if (superclass == null || superclass == Object.class) continue;
                    classesToCheck.add(new AbstractMap.SimpleEntry(superclass, remoteClassObject.getValue()));
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error registering RMI class " + implementationClass, (Throwable)e);
        }
        finally {
            if (kryo != null) {
                manager.returnKryo(kryo);
            }
        }
        return new RmiRegistration(interfaceClass, rmiId, callbackId, object);
    }

    public final RmiRegistration getExistingRmiObject(Class<?> interfaceClass, int rmiId, int callbackId) {
        Object object = this.getImplementationObject(rmiId);
        return new RmiRegistration(interfaceClass, rmiId, callbackId, object);
    }

    public final void runRmiCallback(Class<?> interfaceClass, int callbackId, Object remoteObject) {
        RemoteObjectCallback callback = this.rmiRegistrationCallbacks.remove(callbackId);
        try {
            callback.created(remoteObject);
        }
        catch (Exception e) {
            this.logger.error("Error getting or creating the remote object " + interfaceClass, (Throwable)e);
        }
    }

    @Override
    public <T> int getRegisteredId(T object) {
        RmiBridge globalRmiBridge = this.endPoint.globalRmiBridge;
        if (globalRmiBridge == null) {
            throw new NullPointerException("Unable to call 'getRegisteredId' when the globalRmiBridge is null!");
        }
        int objectId = globalRmiBridge.getRegisteredId(object);
        if (objectId != Integer.MAX_VALUE) {
            return objectId;
        }
        return this.rmiBridge.getRegisteredId(object);
    }

    @Override
    public RemoteObject getProxyObject(int objectID, Class<?> iFace) {
        if (iFace == null) {
            throw new IllegalArgumentException("iface cannot be null.");
        }
        if (!iFace.isInterface()) {
            throw new IllegalArgumentException("iface must be an interface.");
        }
        RemoteObject remoteObject = this.proxyIdCache.get(objectID);
        if (remoteObject == null) {
            RmiProxyHandler proxyObject = new RmiProxyHandler(this, objectID, iFace);
            this.proxyListeners.add(proxyObject.getListener());
            Class[] temp = new Class[]{RemoteObject.class, iFace};
            remoteObject = (RemoteObject)Proxy.newProxyInstance(RmiBridge.class.getClassLoader(), temp, (InvocationHandler)proxyObject);
            this.proxyIdCache.put(objectID, remoteObject);
        }
        return remoteObject;
    }

    @Override
    public Object getImplementationObject(int objectID) {
        if (RmiBridge.isGlobal(objectID)) {
            RmiBridge globalRmiBridge = this.endPoint.globalRmiBridge;
            assert (globalRmiBridge != null);
            return globalRmiBridge.getRegisteredObject(objectID);
        }
        return this.rmiBridge.getRegisteredObject(objectID);
    }
}

